(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'crypto-js'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('crypto-js'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'micro_utils-micro_utils.crypto-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'micro_utils-micro_utils.crypto-js-legacy'.");
    }if (typeof CryptoJS === 'undefined') {
      throw new Error("Error loading module 'micro_utils-micro_utils.crypto-js-legacy'. Its dependency 'crypto-js' was not found. Please, check whether 'crypto-js' is loaded prior to 'micro_utils-micro_utils.crypto-js-legacy'.");
    }root['micro_utils-micro_utils.crypto-js-legacy'] = factory(typeof this['micro_utils-micro_utils.crypto-js-legacy'] === 'undefined' ? {} : this['micro_utils-micro_utils.crypto-js-legacy'], kotlin, CryptoJS);
  }
}(this, function (_, Kotlin, $module$crypto_js) {
  'use strict';
  var toChar = Kotlin.toChar;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var toByte = Kotlin.toByte;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var unboxChar = Kotlin.unboxChar;
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var step = Kotlin.kotlin.ranges.step_xsgg7u$;
  var toByteArray = Kotlin.kotlin.collections.toByteArray_kdx1v$;
  var JsMath = Math;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var get_lastIndex = Kotlin.kotlin.text.get_lastIndex_gw00vp$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var BASE64_ALPHABET;
  var BASE64_MASK;
  var BASE64_PAD;
  var BASE64_INVERSE_ALPHABET;
  function toBase64($receiver) {
    return BASE64_ALPHABET.charCodeAt($receiver);
  }
  function fromBase64($receiver) {
    return toByte(toByte(BASE64_INVERSE_ALPHABET[$receiver & 255]) & BASE64_MASK);
  }
  function encodeBase64String($receiver) {
    return encodeBase64String_0(encodeToByteArray($receiver));
  }
  function encodeBase64($receiver) {
    return encodeBase64_0(encodeToByteArray($receiver));
  }
  function encodeBase64String_0($receiver) {
    var $receiver_0 = StringBuilder_init();
    var i = {v: 0};
    while ($receiver.length > i.v) {
      var b = $receiver.length - i.v | 0;
      var read = JsMath.min(3, b);
      var array = new Int8Array(3);
      var tmp$;
      tmp$ = array.length - 1 | 0;
      for (var i_0 = 0; i_0 <= tmp$; i_0++) {
        var init$result;
        if (i_0 < read) {
          init$result = $receiver[i_0 + i.v | 0];
        } else {
          init$result = 0;
        }
        array[i_0] = init$result;
      }
      var data = array;
      var padSize = ((data.length - read | 0) * 8 | 0) / 6 | 0;
      var chunk = (data[0] & 255) << 16 | (data[1] & 255) << 8 | data[2] & 255;
      for (var index = data.length; index >= padSize; index--) {
        var char = chunk >> (6 * index | 0) & 63;
        $receiver_0.append_s8itvh$(toBase64(char));
      }
      for (var index_0 = 0; index_0 < padSize; index_0++) {
        $receiver_0.append_s8itvh$(BASE64_PAD);
      }
      i.v = i.v + read | 0;
    }
    return $receiver_0.toString();
  }
  function encodeBase64_0($receiver) {
    return encodeToByteArray(encodeBase64String_0($receiver));
  }
  function decodeBase64($receiver) {
    var dropLastWhile$result;
    dropLastWhile$break: do {
      for (var index = get_lastIndex($receiver); index >= 0; index--) {
        if (!(unboxChar(toBoxedChar($receiver.charCodeAt(index))) === BASE64_PAD)) {
          dropLastWhile$result = $receiver.substring(0, index + 1 | 0);
          break dropLastWhile$break;
        }}
      dropLastWhile$result = '';
    }
     while (false);
    return decodeBase64_0(encodeToByteArray(dropLastWhile$result));
  }
  function decodeBase64String($receiver) {
    return decodeToString(decodeBase64($receiver));
  }
  function decodeBase64_0($receiver) {
    var result = ArrayList_init();
    var data = new Int8Array(4);
    var tmp$;
    tmp$ = step(until(0, $receiver.length), 4).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0, tmp$_1;
      var read = 0;
      for (var j = 0; j < 4; j++) {
        if ((j + element | 0) < $receiver.length) {
          data[j] = $receiver[j + element | 0];
          read = read + 1 | 0;
        } else {
          break;
        }
      }
      var tmp$_2, tmp$_0_0;
      var index = 0;
      var accumulator = 0;
      for (tmp$_2 = 0; tmp$_2 !== data.length; ++tmp$_2) {
        var element_0 = data[tmp$_2];
        var index_0 = (tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0);
        accumulator = accumulator | fromBase64(element_0) << ((3 - index_0 | 0) * 6 | 0);
      }
      var chunk = accumulator;
      tmp$_0 = data.length - 2 | 0;
      tmp$_1 = data.length - read | 0;
      for (var index_1 = tmp$_0; index_1 >= tmp$_1; index_1--) {
        var origin = chunk >> (8 * index_1 | 0) & 255;
        result.add_11rb$(toByte(origin));
      }
    }
    return toByteArray(result);
  }
  function decodeBase64String_0($receiver) {
    return decodeToString(decodeBase64_0($receiver));
  }
  function md5($receiver) {
    return md5_0(encodeToByteArray($receiver));
  }
  function md5_0($receiver) {
    return $module$crypto_js.MD5(decodeToString($receiver));
  }
  var package$dev = _.dev || (_.dev = {});
  var package$inmo = package$dev.inmo || (package$dev.inmo = {});
  var package$micro_utils = package$inmo.micro_utils || (package$inmo.micro_utils = {});
  var package$crypto = package$micro_utils.crypto || (package$micro_utils.crypto = {});
  package$crypto.toBase64_8e50z4$ = toBase64;
  package$crypto.fromBase64_nugvp3$ = fromBase64;
  package$crypto.encodeBase64String_pdl1vz$ = encodeBase64String;
  package$crypto.encodeBase64_pdl1vz$ = encodeBase64;
  package$crypto.encodeBase64String_964n91$ = encodeBase64String_0;
  package$crypto.encodeBase64_964n91$ = encodeBase64_0;
  package$crypto.decodeBase64_pdl1vz$ = decodeBase64;
  package$crypto.decodeBase64String_pdl1vz$ = decodeBase64String;
  package$crypto.decodeBase64_964n91$ = decodeBase64_0;
  package$crypto.decodeBase64String_964n91$ = decodeBase64String_0;
  package$crypto.md5_pdl1vz$ = md5;
  package$crypto.md5_964n91$ = md5_0;
  BASE64_ALPHABET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  BASE64_MASK = 63;
  BASE64_PAD = 61;
  var array = new Int32Array(256);
  var tmp$;
  tmp$ = array.length - 1 | 0;
  for (var i = 0; i <= tmp$; i++) {
    array[i] = indexOf(BASE64_ALPHABET, toChar(i));
  }
  BASE64_INVERSE_ALPHABET = array;
  Kotlin.defineModule('micro_utils-micro_utils.crypto-js-legacy', _);
  return _;
}));

//# sourceMappingURL=micro_utils-micro_utils.crypto-js-legacy.js.map
