package dev.inmo.tgbotapi.requests.verifications

import dev.inmo.tgbotapi.abstracts.types.ChatRequest
import dev.inmo.tgbotapi.requests.abstracts.SimpleRequest
import dev.inmo.tgbotapi.types.*
import kotlinx.serialization.DeserializationStrategy
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.SerializationStrategy
import kotlinx.serialization.builtins.serializer


@Serializable
data class VerifyUser(
    @SerialName(userIdField)
    val userId: UserId,
    @SerialName(customDescriptionField)
    val description: String? = null
): SimpleRequest<Boolean> {
    override fun method(): String = "verifyUser"
    override val resultDeserializer: DeserializationStrategy<Boolean>
        get() = Boolean.serializer()
    override val requestSerializer: SerializationStrategy<*>
        get() = serializer()
}
