/*
 * Decompiled with CFR 0.152.
 */
package invirt.data.geo;

import invirt.data.geo.GeoLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Linvirt/data/geo/GeoBoundingBox;", "", "southWest", "Linvirt/data/geo/GeoLocation;", "northEast", "<init>", "(Linvirt/data/geo/GeoLocation;Linvirt/data/geo/GeoLocation;)V", "getSouthWest", "()Linvirt/data/geo/GeoLocation;", "getNorthEast", "points", "", "getPoints", "()Ljava/util/List;", "toLngLatString", "", "toLatLngString", "pad", "delta", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "invirt-data"})
public final class GeoBoundingBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeoLocation southWest;
    @NotNull
    private final GeoLocation northEast;
    @NotNull
    private final List<GeoLocation> points;

    public GeoBoundingBox(@NotNull GeoLocation southWest, @NotNull GeoLocation northEast) {
        Intrinsics.checkNotNullParameter((Object)southWest, (String)"southWest");
        Intrinsics.checkNotNullParameter((Object)northEast, (String)"northEast");
        this.southWest = southWest;
        this.northEast = northEast;
        Object[] objectArray = new GeoLocation[]{this.southWest, new GeoLocation(this.southWest.getLng(), this.northEast.getLat(), null, 4, null), this.northEast, new GeoLocation(this.northEast.getLng(), this.southWest.getLat(), null, 4, null)};
        this.points = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final GeoLocation getSouthWest() {
        return this.southWest;
    }

    @NotNull
    public final GeoLocation getNorthEast() {
        return this.northEast;
    }

    @NotNull
    public final List<GeoLocation> getPoints() {
        return this.points;
    }

    @NotNull
    public final String toLngLatString() {
        return this.southWest.getLng() + "," + this.southWest.getLat() + "," + this.northEast.getLng() + "," + this.northEast.getLat();
    }

    @NotNull
    public final String toLatLngString() {
        return this.southWest.getLat() + "," + this.southWest.getLng() + "," + this.northEast.getLat() + "," + this.northEast.getLng();
    }

    @NotNull
    public final GeoBoundingBox pad(double delta) {
        return new GeoBoundingBox(GeoLocation.Companion.normalised(this.southWest.getLng() + delta, this.southWest.getLat() + delta), GeoLocation.Companion.normalised(this.northEast.getLng() - delta, this.northEast.getLat() - delta));
    }

    @NotNull
    public final GeoLocation component1() {
        return this.southWest;
    }

    @NotNull
    public final GeoLocation component2() {
        return this.northEast;
    }

    @NotNull
    public final GeoBoundingBox copy(@NotNull GeoLocation southWest, @NotNull GeoLocation northEast) {
        Intrinsics.checkNotNullParameter((Object)southWest, (String)"southWest");
        Intrinsics.checkNotNullParameter((Object)northEast, (String)"northEast");
        return new GeoBoundingBox(southWest, northEast);
    }

    public static /* synthetic */ GeoBoundingBox copy$default(GeoBoundingBox geoBoundingBox, GeoLocation geoLocation, GeoLocation geoLocation2, int n, Object object) {
        if ((n & 1) != 0) {
            geoLocation = geoBoundingBox.southWest;
        }
        if ((n & 2) != 0) {
            geoLocation2 = geoBoundingBox.northEast;
        }
        return geoBoundingBox.copy(geoLocation, geoLocation2);
    }

    @NotNull
    public String toString() {
        return "GeoBoundingBox(southWest=" + this.southWest + ", northEast=" + this.northEast + ")";
    }

    public int hashCode() {
        int result = this.southWest.hashCode();
        result = result * 31 + this.northEast.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeoBoundingBox)) {
            return false;
        }
        GeoBoundingBox geoBoundingBox = (GeoBoundingBox)other;
        if (!Intrinsics.areEqual((Object)this.southWest, (Object)geoBoundingBox.southWest)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.northEast, (Object)geoBoundingBox.northEast);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\u0002J\u0015\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00020\t\"\u00020\bH\u0086\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Linvirt/data/geo/GeoBoundingBox$Companion;", "", "<init>", "()V", "invoke", "Linvirt/data/geo/GeoBoundingBox;", "bbox", "", "", "", "fromLngLatString", "", "fromLatLngString", "invirt-data"})
    @SourceDebugExtension(value={"SMAP\nGeoBoundingBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoBoundingBox.kt\ninvirt/data/geo/GeoBoundingBox$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1557#2:51\n1628#2,3:52\n1557#2:55\n1628#2,3:56\n*S KotlinDebug\n*F\n+ 1 GeoBoundingBox.kt\ninvirt/data/geo/GeoBoundingBox$Companion\n*L\n39#1:51\n39#1:52,3\n42#1:55\n42#1:56,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeoBoundingBox invoke(@NotNull List<Double> bbox) {
            Intrinsics.checkNotNullParameter(bbox, (String)"bbox");
            if (bbox.size() != 4) {
                throw new IllegalArgumentException("Bounding box coordinates array must be of size 4");
            }
            return new GeoBoundingBox(GeoLocation.Companion.normalised(((Number)bbox.get(0)).doubleValue(), ((Number)bbox.get(1)).doubleValue()), GeoLocation.Companion.normalised(((Number)bbox.get(2)).doubleValue(), ((Number)bbox.get(3)).doubleValue()));
        }

        @NotNull
        public final GeoBoundingBox invoke(double ... bbox) {
            Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
            return Companion.invoke(ArraysKt.toList((double[])bbox));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GeoBoundingBox fromLngLatString(@NotNull String bbox) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)bbox, (String[])object, (boolean)false, (int)0, (int)6, null);
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.parseDouble((String)it));
            }
            return companion.invoke((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GeoBoundingBox fromLatLngString(@NotNull String bbox) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)bbox, (String)"bbox");
            Object[] objectArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)bbox, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.parseDouble((String)it));
            }
            List elements = (List)destination$iv$iv;
            if (elements.size() != 4) {
                throw new IllegalArgumentException("Bounding box coordinates array must be of size 4");
            }
            objectArray = new double[4];
            objectArray[0] = (String)((Number)elements.get(1)).doubleValue();
            objectArray[1] = (String)((Number)elements.get(0)).doubleValue();
            objectArray[2] = (String)((Number)elements.get(3)).doubleValue();
            objectArray[3] = (String)((Number)elements.get(2)).doubleValue();
            return Companion.invoke((double[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

