/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkFileDependency;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class JkFileSystemDependency
implements JkFileDependency {
    private final Path ideProjectDir;
    private final List<Path> files;

    private JkFileSystemDependency(Iterable<Path> files, Path ideProjectDir) {
        this.files = Collections.unmodifiableList(JkUtilsIterable.listWithoutDuplicateOf(files));
        this.ideProjectDir = ideProjectDir;
    }

    public static JkFileSystemDependency of(Iterable<Path> files) {
        List<Path> trueFiles = JkUtilsPath.disambiguate(files);
        return new JkFileSystemDependency(trueFiles, null);
    }

    @Override
    public final List<Path> getFiles() {
        return this.files;
    }

    public JkFileSystemDependency minusFile(Path file) {
        LinkedList<Path> result = new LinkedList<Path>(this.files);
        result.remove(file);
        return new JkFileSystemDependency(result, this.ideProjectDir);
    }

    public String toString() {
        return "Files=" + this.files.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkFileSystemDependency that = (JkFileSystemDependency)o;
        return this.files.equals(that.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    @Override
    public Path getIdeProjectDir() {
        return this.ideProjectDir;
    }

    @Override
    public JkFileSystemDependency withIdeProjectDir(Path path) {
        return new JkFileSystemDependency(this.files, path);
    }
}

