/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class JkProjectDependencies {
    private static final String COMPILE_AND_RUNTIME = "compile+runtime";
    private static final String COMPILE = "compile";
    private static final String RUNTIME = "runtime";
    private static final String TEST = "test";
    private static final List<String> KNOWN_QUALIFIER = JkUtilsIterable.listOf("compile", "compile+runtime", "runtime", "test");
    private final JkDependencySet compile;
    private final JkDependencySet runtime;
    private final JkDependencySet test;

    private JkProjectDependencies(JkDependencySet compile, JkDependencySet runtime, JkDependencySet test) {
        this.compile = compile;
        this.runtime = runtime;
        this.test = test;
    }

    public static JkProjectDependencies of(JkDependencySet compile, JkDependencySet runtime, JkDependencySet test) {
        return new JkProjectDependencies(compile, runtime, test);
    }

    static JkProjectDependencies of() {
        return JkProjectDependencies.of(JkDependencySet.of(), JkDependencySet.of(), JkDependencySet.of());
    }

    public static JkProjectDependencies ofLocal(Path baseDir) {
        JkPathTree libDir = JkPathTree.of(baseDir);
        if (!libDir.exists()) {
            return JkProjectDependencies.of();
        }
        JkDependencySet compile = JkDependencySet.of().andFiles(libDir.andMatching(true, "*.jar", "compile/*.jar").getFiles()).andFiles(libDir.andMatching(true, "compile+runtime/*.jar").getFiles());
        JkDependencySet runtime = JkDependencySet.of().andFiles(libDir.andMatching(true, "*.jar", "runtime/*.jar").getFiles()).andFiles(libDir.andMatching(true, "compile+runtime/*.jar").getFiles());
        JkDependencySet test = JkDependencySet.of().andFiles(libDir.andMatching(true, "*.jar", "test/*.jar").getFiles());
        return JkProjectDependencies.of(compile, runtime, test);
    }

    public static JkProjectDependencies ofTextDescription(Path path) {
        return JkProjectDependencies.ofTextDescription(JkUtilsPath.toUrl(path));
    }

    public static JkProjectDependencies ofTextDescriptionIfExist(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return JkProjectDependencies.of();
        }
        return JkProjectDependencies.ofTextDescription(JkUtilsPath.toUrl(path));
    }

    public static JkProjectDependencies ofTextDescription(URL url) {
        return JkProjectDependencies.ofTextDescription(JkUtilsIO.read(url));
    }

    public static JkProjectDependencies ofTextDescription(String description) {
        String[] lines = description.split(System.lineSeparator());
        JkDependencySet compile = JkDependencySet.of();
        JkDependencySet runtime = JkDependencySet.of();
        JkDependencySet test = JkDependencySet.of();
        String currentQualifier = COMPILE_AND_RUNTIME;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            if (line.startsWith("-")) {
                currentQualifier = JkProjectDependencies.readQualifier(line);
                continue;
            }
            JkModuleDependency dependency = JkModuleDependency.of(line.trim());
            if (COMPILE_AND_RUNTIME.equals(currentQualifier) || COMPILE.equals(currentQualifier)) {
                compile = compile.and(dependency);
            }
            if (COMPILE_AND_RUNTIME.equals(currentQualifier) || RUNTIME.equals(currentQualifier)) {
                runtime = runtime.and(dependency);
                continue;
            }
            if (!TEST.equals(currentQualifier)) continue;
            test = test.and(dependency);
        }
        return JkProjectDependencies.of(compile, runtime, test);
    }

    private static String readQualifier(String line) {
        String payload = JkUtilsString.substringAfterFirst(line, "-").trim().toLowerCase();
        if (KNOWN_QUALIFIER.contains(payload)) {
            return payload;
        }
        return COMPILE_AND_RUNTIME;
    }

    public JkDependencySet getCompile() {
        return this.compile;
    }

    public JkDependencySet getRuntime() {
        return this.runtime;
    }

    public JkDependencySet getTest() {
        return this.test;
    }

    public JkProjectDependencies and(JkProjectDependencies other) {
        return JkProjectDependencies.of(this.compile.and(other.compile), this.runtime.and(other.runtime), this.test.and(other.test));
    }
}

