/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsFile;
import dev.jeka.core.api.utils.JkUtilsIterable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class JkRepo {
    private static final String LOCAL_NAME = "local";
    public static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2";
    public static final String MAVEN_OSSRH_DOWNLOAD_AND_DEPLOY_SNAPSHOT = "https://oss.sonatype.org/content/repositories/snapshots/";
    public static final String MAVEN_OSSRH_DOWNLOAD_RELEASE = "https://oss.sonatype.org/content/repositories/releases/";
    public static final String MAVEN_OSSRH_DEPLOY_RELEASE = "https://oss.sonatype.org/service/local/staging/deploy/maven2/";
    public static final String MAVEN_OSSRH_PUBLIC_DOWNLOAD_RELEASE_AND_SNAPSHOT = "https://oss.sonatype.org/content/groups/public/";
    private static final String IVY_PREFIX = "ivy:";
    private final URL url;
    private JkRepoCredentials credentials;
    private JkRepoIvyConfig ivyConfig = new JkRepoIvyConfig(this);
    private JkPublishConfig publishConfig = new JkPublishConfig(this);
    public final boolean ivyRepo;

    private JkRepo(URL url, boolean ivyRepo) {
        this.url = url;
        this.ivyRepo = ivyRepo;
    }

    public static JkRepo of(String url) {
        if (url.equals(LOCAL_NAME)) {
            return JkRepo.ofLocal();
        }
        if (url.toLowerCase().startsWith(IVY_PREFIX)) {
            return new JkRepo(JkRepo.toUrl(url.substring(4)), true);
        }
        return new JkRepo(JkRepo.toUrl(url), false);
    }

    public static JkRepo of(Path dir) {
        dir = dir.isAbsolute() ? dir : dir.toAbsolutePath().normalize();
        return JkRepo.of(dir.toString());
    }

    public static JkRepo ofMavenCentral() {
        return JkRepo.of(MAVEN_CENTRAL_URL);
    }

    public static JkRepo ofMavenOssrhDownloadAndDeploySnapshot(String jiraId, String jiraPassword) {
        return JkRepo.of((String)MAVEN_OSSRH_DOWNLOAD_AND_DEPLOY_SNAPSHOT).setCredentials((JkRepoCredentials)JkRepoCredentials.of((String)jiraId, (String)jiraPassword, (String)"Sonatype Nexus Repository Manager")).getPublishConfig().setUniqueSnapshot((boolean)false).setVersionFilter((Predicate<JkVersion>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isSnapshot(), (Ldev/jeka/core/api/depmanagement/JkVersion;)Z)()).__;
    }

    public static JkRepo ofMavenOssrhDeployRelease(String jiraId, String jiraPassword, UnaryOperator<Path> signer) {
        return JkRepo.of((String)MAVEN_OSSRH_DEPLOY_RELEASE).setCredentials((String)jiraId, (String)jiraPassword, (String)"Sonatype Nexus Repository Manager").getPublishConfig().setSignatureRequired((boolean)true).setVersionFilter((Predicate<JkVersion>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$ofMavenOssrhDeployRelease$0(dev.jeka.core.api.depmanagement.JkVersion ), (Ldev/jeka/core/api/depmanagement/JkVersion;)Z)()).setSigner(signer).setChecksumAlgos((String[])new String[]{"md5", "sha1"}).__;
    }

    public static JkRepo ofMavenOssrhPublicDownload() {
        return JkRepo.of(MAVEN_OSSRH_PUBLIC_DOWNLOAD_RELEASE_AND_SNAPSHOT);
    }

    public static JkRepo ofLocal() {
        Path file = JkLocator.getJekaUserHomeDir().resolve("maven-publish-dir");
        return JkRepo.of(file);
    }

    public static JkRepo ofLocalIvy() {
        Path file = JkLocator.getJekaUserHomeDir().resolve("ivy-publish-dir");
        return JkRepo.of(IVY_PREFIX + file);
    }

    public final URL getUrl() {
        return this.url;
    }

    public JkRepoIvyConfig getIvyConfig() {
        return this.ivyConfig;
    }

    public boolean isIvyRepo() {
        return this.ivyRepo;
    }

    public boolean isLocal() {
        return this.url.getProtocol().equals("file");
    }

    public final JkRepoCredentials getCredentials() {
        return this.credentials;
    }

    public JkPublishConfig getPublishConfig() {
        return this.publishConfig;
    }

    public JkRepo setCredentials(JkRepoCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public JkRepo setCredentials(String username, String password, String realm) {
        return this.setCredentials(JkRepoCredentials.of(username, password, realm));
    }

    public JkRepo setCredentials(String username, String password) {
        return this.setCredentials(username, password, null);
    }

    public JkRepoSet toSet() {
        return JkRepoSet.of(this, new JkRepo[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkRepo jkRepo = (JkRepo)o;
        return this.url.equals(jkRepo.url);
    }

    public JkRepo copy() {
        JkRepo result = new JkRepo(this.url, this.ivyRepo);
        result.credentials = this.credentials;
        result.ivyConfig = this.ivyConfig.copy(result);
        result.publishConfig = this.publishConfig.copy(result);
        return result;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url.toString();
    }

    private static URL toUrl(String urlOrDir) {
        try {
            return new URL(urlOrDir);
        }
        catch (MalformedURLException e) {
            File file = new File(urlOrDir);
            if (file.isAbsolute()) {
                return JkUtilsFile.toUrl(file);
            }
            throw new IllegalArgumentException("<Malformed url " + urlOrDir, e);
        }
    }

    private static /* synthetic */ boolean lambda$ofMavenOssrhDeployRelease$0(JkVersion version) {
        return !version.isSnapshot();
    }

    public static class JkPublishConfig {
        public final JkRepo __;
        private Predicate<JkVersion> versionFilter = jkVersion -> true;
        private boolean signatureRequired;
        private boolean uniqueSnapshot;
        private Set<String> checksumAlgos = new HashSet<String>();
        private UnaryOperator<Path> signer;

        private JkPublishConfig(JkRepo parent) {
            this.__ = parent;
        }

        public Predicate<JkVersion> getVersionFilter() {
            return this.versionFilter;
        }

        public boolean isSignatureRequired() {
            return this.signatureRequired;
        }

        public boolean isUniqueSnapshot() {
            return this.uniqueSnapshot;
        }

        public Set<String> getChecksumAlgos() {
            return this.checksumAlgos;
        }

        public UnaryOperator<Path> getSigner() {
            return this.signer;
        }

        public JkPublishConfig setUniqueSnapshot(boolean uniqueSnapshot) {
            this.uniqueSnapshot = uniqueSnapshot;
            return this;
        }

        public JkPublishConfig setSignatureRequired(boolean signatureRequired) {
            this.signatureRequired = signatureRequired;
            return this;
        }

        public JkPublishConfig setVersionFilter(Predicate<JkVersion> versionFilter) {
            JkUtilsAssert.argument(versionFilter != null, "Filter cannot be null.", new Object[0]);
            this.versionFilter = versionFilter;
            return this;
        }

        public JkPublishConfig setChecksumAlgos(String ... algos) {
            this.checksumAlgos = JkUtilsIterable.setOf(algos);
            return this;
        }

        public JkPublishConfig setSigner(UnaryOperator<Path> signer) {
            this.signer = signer;
            return this;
        }

        private JkPublishConfig copy(JkRepo parent) {
            JkPublishConfig result = new JkPublishConfig(parent);
            result.signer = this.signer;
            result.checksumAlgos = new HashSet<String>(this.checksumAlgos);
            result.signatureRequired = this.signatureRequired;
            result.uniqueSnapshot = this.uniqueSnapshot;
            result.versionFilter = this.versionFilter;
            return result;
        }
    }

    public static final class JkRepoIvyConfig {
        public static final String DEFAULT_IVY_ARTIFACT_PATTERN = "[organisation]/[module]/[type]s/[artifact]-[revision](-[type]).[ext]";
        public static final String DEFAULT_IVY_IVY_PATTERN = "[organisation]/[module]/ivy-[revision].xml";
        public final JkRepo __;
        private final List<String> artifactPatterns;
        private final List<String> ivyPatterns;

        private JkRepoIvyConfig(JkRepo parent) {
            this.__ = parent;
            this.artifactPatterns = new LinkedList<String>(JkUtilsIterable.listOf(DEFAULT_IVY_ARTIFACT_PATTERN));
            this.ivyPatterns = new LinkedList<String>(JkUtilsIterable.listOf(DEFAULT_IVY_IVY_PATTERN));
        }

        public List<String> artifactPatterns() {
            return Collections.unmodifiableList(this.artifactPatterns);
        }

        public List<String> ivyPatterns() {
            return Collections.unmodifiableList(this.ivyPatterns);
        }

        public JkRepoIvyConfig emptyArtifactPatterns() {
            this.artifactPatterns.clear();
            return this;
        }

        public JkRepoIvyConfig addArtifactPatterns(String ... patterns) {
            this.artifactPatterns.addAll(Arrays.asList(patterns));
            return this;
        }

        public JkRepoIvyConfig emptyIvyPatterns() {
            this.ivyPatterns.clear();
            return this;
        }

        public JkRepoIvyConfig addIvyPatterns(String ... patterns) {
            this.ivyPatterns.addAll(Arrays.asList(patterns));
            return this;
        }

        private JkRepoIvyConfig copy(JkRepo parent) {
            JkRepoIvyConfig result = new JkRepoIvyConfig(parent);
            result.artifactPatterns.clear();
            result.artifactPatterns.addAll(this.artifactPatterns);
            result.ivyPatterns.clear();
            result.ivyPatterns.addAll(this.ivyPatterns);
            return result;
        }
    }

    public static final class JkRepoCredentials {
        private final String realm;
        private final String userName;
        private final String password;

        private JkRepoCredentials(String realm, String userName, String password) {
            this.realm = realm;
            this.userName = userName;
            this.password = password;
        }

        public static JkRepoCredentials of(String username, String password) {
            return new JkRepoCredentials(null, username, password);
        }

        public static JkRepoCredentials of(String username, String password, String realm) {
            return new JkRepoCredentials(realm, username, password);
        }

        public String getRealm() {
            return this.realm;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isEmpty() {
            return this.userName == null && this.password == null;
        }
    }
}

