/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.system.JkProperty;
import dev.jeka.core.api.utils.JkUtilsAssert;

public class JkRepoFromProperties {
    public static JkRepo getPublishRepository() {
        String repoName = JkProperty.get("jeka.repos.publish.name");
        if (repoName != null) {
            return JkRepoFromProperties.getNamedRepo(repoName);
        }
        if (JkProperty.get("jeka.repos.publish.url") != null) {
            return JkRepoFromProperties.ofPrefix("jeka.repos.publish");
        }
        return JkRepo.ofMavenCentral();
    }

    public static JkRepo getDownloadRepo() {
        String repoName = JkProperty.get("jeka.repos.download.name");
        if (repoName != null) {
            return JkRepoFromProperties.getNamedRepo(repoName);
        }
        if (JkProperty.get("jeka.repos.download.url") != null) {
            return JkRepoFromProperties.ofPrefix("jeka.repos.download");
        }
        return JkRepo.ofMavenCentral();
    }

    public static JkRepo getNamedRepo(String repoName) {
        String namedRepoOptionPrefix = "jeka.repos." + repoName;
        return JkRepoFromProperties.ofPrefix(namedRepoOptionPrefix);
    }

    private static JkRepo ofPrefix(String prefix) {
        String url = JkProperty.get(prefix + ".url");
        JkUtilsAssert.argument(url != null, "No option defined for " + prefix + ".url", new Object[0]);
        String username = JkProperty.get(prefix + ".username");
        String password = JkProperty.get(prefix + "..password");
        return JkRepo.of(url.trim()).setCredentials(username, password);
    }
}

