/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.resolution.JkInternalDependencyResolver;
import dev.jeka.core.api.utils.JkUtilsIterable;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class JkRepoSet {
    private transient JkInternalDependencyResolver internalDependencyResolver;
    private final List<JkRepo> repos;

    private JkRepoSet(List<JkRepo> repos) {
        this.repos = Collections.unmodifiableList(repos);
    }

    public static JkRepoSet of(Iterable<JkRepo> configs) {
        return new JkRepoSet(JkUtilsIterable.listOf(configs));
    }

    public static JkRepoSet of(JkRepo repo, JkRepo ... others) {
        return new JkRepoSet(JkUtilsIterable.listOf1orMore(repo, others));
    }

    public static JkRepoSet of(String ... urls) {
        LinkedList<JkRepo> list = new LinkedList<JkRepo>();
        for (String url : urls) {
            list.add(JkRepo.of(url));
        }
        return new JkRepoSet(list);
    }

    public JkRepoSet and(JkRepo other) {
        LinkedList<JkRepo> list = new LinkedList<JkRepo>(this.repos);
        list.add(other);
        return new JkRepoSet(list);
    }

    public JkRepoSet and(JkRepoSet other) {
        LinkedList<JkRepo> list = new LinkedList<JkRepo>(this.repos);
        list.addAll(other.repos);
        return new JkRepoSet(list);
    }

    public static JkRepoSet ofLocal() {
        return JkRepoSet.of(JkRepo.ofLocal(), new JkRepo[0]);
    }

    public static JkRepoSet ofOssrhSnapshotAndRelease(String userName, String password, UnaryOperator<Path> signer) {
        return JkRepoSet.of(JkRepo.ofMavenOssrhDownloadAndDeploySnapshot(userName, password), JkRepo.ofMavenOssrhDeployRelease(userName, password, signer));
    }

    public JkRepo getRepoConfigHavingUrl(String url) {
        for (JkRepo config : this.repos) {
            if (!url.equals(config.getUrl().toExternalForm())) continue;
            return config;
        }
        return null;
    }

    public List<JkRepo> getRepos() {
        return this.repos;
    }

    public boolean contains(URL url) {
        return this.repos.stream().anyMatch(repo -> url.equals(repo.getUrl()));
    }

    public String toString() {
        return this.repos.toString();
    }

    public Path get(JkModuleDependency moduleDependency) {
        JkInternalDependencyResolver depResolver = this.getInternalDependencyResolver();
        File file = depResolver.get(moduleDependency);
        if (file == null) {
            return null;
        }
        return depResolver.get(moduleDependency).toPath();
    }

    public Path get(JkModuleId moduleId, String version) {
        return this.get(JkModuleDependency.of(moduleId, version));
    }

    public Path get(String moduleGroupVersion) {
        return this.get(JkModuleDependency.of(moduleGroupVersion));
    }

    public Path get(JkVersionedModule versionedModule) {
        return this.get(JkModuleDependency.of(versionedModule));
    }

    public JkRepoSet withDefaultSigner(UnaryOperator<Path> signer) {
        List<JkRepo> reposCopy = this.repos.stream().map(repo -> {
            if (repo.getPublishConfig().getSigner() == null && repo.getPublishConfig().isSignatureRequired()) {
                JkRepo repoCopy = repo.copy();
                repoCopy.getPublishConfig().setSigner(signer);
                return repoCopy;
            }
            return repo;
        }).collect(Collectors.toList());
        return new JkRepoSet(reposCopy);
    }

    private JkInternalDependencyResolver getInternalDependencyResolver() {
        if (this.internalDependencyResolver == null) {
            this.internalDependencyResolver = JkInternalDependencyResolver.of(this);
        }
        return this.internalDependencyResolver;
    }
}

