/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsString;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class JkVersionProvider {
    private final Map<JkModuleId, JkVersion> map;
    private final List<JkModuleDependency> boms;

    private JkVersionProvider(Map<JkModuleId, JkVersion> map, List<JkModuleDependency> boms) {
        this.map = map;
        this.boms = boms;
    }

    public static JkVersionProvider of(String moduleId, String version) {
        return JkVersionProvider.of(JkModuleId.of(moduleId), version);
    }

    public static JkVersionProvider of(JkModuleId moduleId, String version) {
        return JkVersionProvider.of(moduleId, JkVersion.of(version));
    }

    public static JkVersionProvider of(JkModuleId moduleId, JkVersion version) {
        Map<JkModuleId, JkVersion> result = JkUtilsIterable.mapOf(moduleId, version, new Object[0]);
        return new JkVersionProvider(result, Collections.emptyList());
    }

    public static JkVersionProvider of() {
        return new JkVersionProvider(Collections.emptyMap(), Collections.emptyList());
    }

    public static JkVersionProvider of(Iterable<JkVersionedModule> modules) {
        HashMap<JkModuleId, JkVersion> result = new HashMap<JkModuleId, JkVersion>();
        for (JkVersionedModule module : modules) {
            result.put(module.getModuleId(), module.getVersion());
        }
        return new JkVersionProvider(result, Collections.emptyList());
    }

    public JkVersion getVersionOf(JkModuleId moduleId) {
        return this.map.get(moduleId);
    }

    public String getVersionOf(String moduleId) {
        return this.getVersionOf(JkModuleId.of(moduleId)).getValue();
    }

    public JkDependency version(JkDependency dependency) {
        if (!(dependency instanceof JkModuleDependency)) {
            return dependency;
        }
        JkModuleDependency moduleDependency = (JkModuleDependency)dependency;
        JkVersion providedVersion = this.getVersionOf(moduleDependency.getModuleId());
        if (moduleDependency.getVersion().isUnspecified() && providedVersion != null) {
            return moduleDependency.withVersion(providedVersion);
        }
        return moduleDependency;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public JkVersionProvider and(JkVersionProvider other) {
        HashMap<JkModuleId, JkVersion> newMap = new HashMap<JkModuleId, JkVersion>(this.map);
        newMap.putAll(other.map);
        LinkedList<JkModuleDependency> newBoms = new LinkedList<JkModuleDependency>(this.boms);
        newBoms.addAll(other.boms);
        return new JkVersionProvider(newMap, newBoms);
    }

    public JkVersionProvider and(JkModuleId moduleId, JkVersion version) {
        HashMap<JkModuleId, JkVersion> newMap = new HashMap<JkModuleId, JkVersion>(this.map);
        newMap.put(moduleId, version);
        return new JkVersionProvider(newMap, this.boms);
    }

    public JkVersionProvider and(JkModuleId moduleId, String version) {
        return this.and(moduleId, JkVersion.of(version));
    }

    public JkVersionProvider andBom(String dependencyDescription) {
        JkModuleDependency moduleDependency;
        String[] items = dependencyDescription.split(":");
        if (items.length == 5) {
            moduleDependency = JkModuleDependency.of(dependencyDescription);
        } else if (items.length == 3) {
            JkModuleId moduleId = JkModuleId.of(items[0], items[1]);
            JkVersion version = JkVersion.of(items[2]);
            moduleDependency = JkModuleDependency.of(moduleId, version).withClassifiersAndType("", "pom");
        } else {
            throw new IllegalArgumentException("dependencyDescription must be expressed as 'group:name::pom:version' or 'group:name:version'. was " + dependencyDescription);
        }
        LinkedList<JkModuleDependency> newBoms = new LinkedList<JkModuleDependency>(this.boms);
        newBoms.add(moduleDependency);
        return new JkVersionProvider(this.map, newBoms);
    }

    public JkVersionProvider and(String versionedModule) {
        JkUtilsAssert.argument(versionedModule.split(":").length == 3, "versioned module should be expressed as 'group:name:version' was '%s'", versionedModule);
        String groupAndName = JkUtilsString.substringBeforeLast(versionedModule, ":");
        String version = JkUtilsString.substringAfterLast(versionedModule, ":");
        return this.and(groupAndName, version);
    }

    public JkVersionProvider and(String moduleId, String version) {
        return this.and(JkModuleId.of(moduleId), version);
    }

    public JkVersionProvider and(String group, String name, String version) {
        return this.and(JkModuleId.of(group, name), version);
    }

    public Set<JkModuleId> getModuleIds() {
        return this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public Map<JkModuleId, JkVersion> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public String toJavaCode(int margin) {
        String indent = JkUtilsString.repeat(" ", margin);
        StringBuilder builder = new StringBuilder();
        builder.append("JkVersionProvider.of()");
        for (Map.Entry<JkModuleId, JkVersion> entry : this.map.entrySet()) {
            JkModuleId moduleId = entry.getKey();
            JkVersion version = entry.getValue();
            builder.append("\n").append(indent).append(".and(\"").append(moduleId.getGroupAndName() + "\", ").append("\"" + version + "\")");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkVersionProvider that = (JkVersionProvider)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public JkVersionProvider resolveBoms(Function<JkModuleDependency, JkVersionProvider> bomResolver) {
        JkVersionProvider provider = this.boms.stream().distinct().map(module -> (JkVersionProvider)bomResolver.apply((JkModuleDependency)module)).reduce(this, (versionProvider1, versionProvider2) -> versionProvider1.and((JkVersionProvider)versionProvider2));
        return new JkVersionProvider(provider.map, Collections.emptyList());
    }
}

