/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.utils.JkUtilsAssert;

public final class JkVersionedModule {
    private final JkModuleId moduleId;
    private final JkVersion version;

    private JkVersionedModule(JkModuleId moduleId, JkVersion version) {
        this.moduleId = moduleId;
        this.version = version == null ? JkVersion.UNSPECIFIED : version;
    }

    public static JkVersionedModule of(JkModuleId moduleId, JkVersion version) {
        JkUtilsAssert.argument(version != null, "Null version specified for " + moduleId + ". Must be at least UNSPECIFIED.", new Object[0]);
        return new JkVersionedModule(moduleId, version);
    }

    public static JkVersionedModule ofUnspecifiedVerion(JkModuleId moduleId) {
        return JkVersionedModule.of(moduleId, JkVersion.UNSPECIFIED);
    }

    public static JkVersionedModule of(String description) {
        String[] items = description.split(":");
        if (items.length != 3) {
            throw new IllegalArgumentException(description + " does not respect format groupId:name:version");
        }
        return JkVersionedModule.of(JkModuleId.of(items[0], items[1]), JkVersion.of(items[2]));
    }

    public static JkVersionedModule ofRootDirName(String rootDirName) {
        return JkVersionedModule.ofUnspecifiedVerion(JkModuleId.of(rootDirName));
    }

    public JkModuleId getModuleId() {
        return this.moduleId;
    }

    public JkVersion getVersion() {
        return this.version;
    }

    public JkVersionedModule withVersion(JkVersion version) {
        return JkVersionedModule.of(this.moduleId, version);
    }

    public JkVersionedModule withVersion(String version) {
        return this.withVersion(JkVersion.of(version));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkVersionedModule that = (JkVersionedModule)o;
        if (!this.moduleId.equals(that.moduleId)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.moduleId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.moduleId + ":" + this.version;
    }

    public JkVersionedModule resolveConflict(JkVersion other, ConflictStrategy strategy) {
        if (this.version.isUnspecified()) {
            return this.withVersion(other);
        }
        if (other.isUnspecified()) {
            return this;
        }
        if (strategy == ConflictStrategy.FAIL && !this.version.equals(other)) {
            throw new IllegalStateException("Module " + this.moduleId + " has been declared with both version '" + this.version + "' and '" + other + "'");
        }
        if (this.version.isSnapshot() && !other.isSnapshot()) {
            return this.withVersion(other);
        }
        if (!this.version.isSnapshot() && other.isSnapshot()) {
            return this;
        }
        if (strategy == ConflictStrategy.TAKE_FIRST) {
            return this;
        }
        return strategy == ConflictStrategy.TAKE_HIGHEST && this.version.isGreaterThan(other) ? this : this.withVersion(other);
    }

    public static enum ConflictStrategy {
        TAKE_FIRST,
        TAKE_HIGHEST,
        TAKE_LOWEST,
        FAIL;

    }
}

