/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.artifact;

import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.utils.JkUtilsIterable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public interface JkArtifactLocator {
    public Path getArtifactPath(JkArtifactId var1);

    default public JkArtifactId getMainArtifactId() {
        return JkArtifactId.of("", this.getMainArtifactExt());
    }

    default public String getMainArtifactExt() {
        return "jar";
    }

    default public List<JkArtifactId> getArtifactIds() {
        return JkUtilsIterable.listOf(this.getMainArtifactId());
    }

    default public Path getMainArtifactPath() {
        return this.getArtifactPath(this.getMainArtifactId());
    }

    default public List<Path> getMissingFiles() {
        return this.getArtifactIds().stream().map(this::getArtifactPath).filter(path -> !Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
    }
}

