/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.artifact;

import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactProducer;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class JkStandardFileArtifactProducer<T>
implements JkArtifactProducer {
    public final T __;
    private final Map<JkArtifactId, Consumer<Path>> consumers = new LinkedHashMap<JkArtifactId, Consumer<Path>>();
    private Function<JkArtifactId, Path> artifactFileFunction;
    private String mainArtifactExt = "jar";

    private JkStandardFileArtifactProducer(T __) {
        this.__ = __;
    }

    public static <T> JkStandardFileArtifactProducer<T> ofParent(T __) {
        return new JkStandardFileArtifactProducer<T>(__);
    }

    public static JkStandardFileArtifactProducer<Void> of() {
        return new JkStandardFileArtifactProducer<Object>(null);
    }

    public static JkStandardFileArtifactProducer<Void> of(Function<JkArtifactId, Path> artifactPathFunction) {
        return new JkStandardFileArtifactProducer<Object>(null).setArtifactFilenameComputation(artifactPathFunction);
    }

    @Override
    public void makeArtifact(JkArtifactId artifactId) {
        Consumer<Path> consumer = this.consumers.get(artifactId);
        if (consumer == null) {
            throw new IllegalArgumentException("No artifact " + artifactId + " defined on this producer. Artifact defined are : " + this.consumers.entrySet());
        }
        Path path = this.getArtifactPath(artifactId);
        JkLog.startTask("Make artifact " + path.getFileName(), new Object[0]);
        consumer.accept(path);
        JkLog.info("Artifact created at " + JkUtilsPath.relativizeFromWorkingDir(path), new Object[0]);
        JkLog.endTask();
    }

    @Override
    public Path getArtifactPath(JkArtifactId artifactId) {
        JkUtilsAssert.state(this.artifactFileFunction != null, "artifactFileFunction has not been set.", new Object[0]);
        return this.artifactFileFunction.apply(artifactId);
    }

    @Override
    public List<JkArtifactId> getArtifactIds() {
        return new LinkedList<JkArtifactId>(this.consumers.keySet());
    }

    public JkStandardFileArtifactProducer<T> setArtifactFilenameComputation(Function<JkArtifactId, Path> artifactFileFunction) {
        JkUtilsAssert.argument(artifactFileFunction != null, "artifactFileFunction cannot be null.", new Object[0]);
        this.artifactFileFunction = artifactFileFunction;
        return this;
    }

    public JkStandardFileArtifactProducer<T> putArtifact(JkArtifactId artifactId, Consumer<Path> artifactFileMaker) {
        this.consumers.put(artifactId, artifactFileMaker);
        return this;
    }

    public JkStandardFileArtifactProducer<T> putArtifact(String name, String ext, Consumer<Path> artifactFileMaker) {
        return this.putArtifact(JkArtifactId.of(name, ext), artifactFileMaker);
    }

    public JkStandardFileArtifactProducer<T> putMainArtifact(Consumer<Path> artifactFileMaker) {
        return this.putArtifact(this.getMainArtifactId(), artifactFileMaker);
    }

    public JkStandardFileArtifactProducer<T> removeArtifact(JkArtifactId artifactId) {
        this.consumers.remove(artifactId);
        return this;
    }

    public JkStandardFileArtifactProducer<T> removeArtifact(String name, String ext) {
        return this.removeArtifact(JkArtifactId.of(name, ext));
    }

    @Override
    public String getMainArtifactExt() {
        return this.mainArtifactExt;
    }

    public JkStandardFileArtifactProducer<T> setMainArtifactExt(String mainArtifactExt) {
        this.mainArtifactExt = mainArtifactExt;
        return this;
    }
}

