/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.artifact;

import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactProducer;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.system.JkLog;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class JkSuppliedFileArtifactProducer<T>
implements JkArtifactProducer {
    private static final Supplier<JkPathSequence> EMPTY_SUPPLIER = () -> JkPathSequence.of();
    public final T __;
    private final Map<JkArtifactId, FileRunnable> fileRunnables = new HashMap<JkArtifactId, FileRunnable>();
    private String mainArtifactExt = "jar";

    private JkSuppliedFileArtifactProducer(T __) {
        this.__ = __;
    }

    public static <T> JkSuppliedFileArtifactProducer<T> ofParent(T __) {
        return new JkSuppliedFileArtifactProducer<T>(__);
    }

    public static JkSuppliedFileArtifactProducer<Void> of() {
        return JkSuppliedFileArtifactProducer.ofParent(null);
    }

    @Override
    public void makeArtifact(JkArtifactId artifactId) {
        FileRunnable fileRunnable = this.fileRunnables.get(artifactId);
        if (fileRunnable == null) {
            throw new IllegalArgumentException("No artifact " + artifactId + " defined on this producer. Artifact defined are : " + this.fileRunnables.entrySet());
        }
        Path path = fileRunnable.file;
        JkLog.startTask("Make artifact " + path.getFileName(), new Object[0]);
        fileRunnable.runnable.run();
        Path relPath = path.isAbsolute() ? Paths.get("", new String[0]).toAbsolutePath().relativize(path) : path;
        JkLog.info("Artifact created at " + relPath, new Object[0]);
        JkLog.endTask();
    }

    @Override
    public Path getArtifactPath(JkArtifactId artifactId) {
        FileRunnable fileRunnable = this.fileRunnables.get(artifactId);
        return fileRunnable == null ? null : fileRunnable.file;
    }

    @Override
    public List<JkArtifactId> getArtifactIds() {
        return new LinkedList<JkArtifactId>(this.fileRunnables.keySet());
    }

    public JkSuppliedFileArtifactProducer<T> putArtifact(JkArtifactId artifactId, Path target, Runnable fileMaker) {
        this.fileRunnables.put(artifactId, new FileRunnable(target, fileMaker));
        return this;
    }

    public JkSuppliedFileArtifactProducer<T> putMainArtifact(Path target, Runnable fileMaker) {
        return this.putArtifact(this.getMainArtifactId(), target, fileMaker);
    }

    public JkSuppliedFileArtifactProducer<T> removeArtifact(JkArtifactId artifactId) {
        this.fileRunnables.remove(artifactId);
        return this;
    }

    @Override
    public String getMainArtifactExt() {
        return this.mainArtifactExt;
    }

    public JkSuppliedFileArtifactProducer<T> setMainArtifactExt(String mainArtifactExt) {
        this.mainArtifactExt = mainArtifactExt;
        return this;
    }

    private static class FileRunnable {
        final Runnable runnable;
        final Path file;

        public FileRunnable(Path file, Runnable runnable) {
            this.runnable = runnable;
            this.file = file;
        }
    }
}

