/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.publication;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JkMavenMetadata {
    private String modelVersion;
    private String groupId;
    private String artifactId;
    private String version;
    private Versioning versioning = new Versioning();

    public static JkMavenMetadata of(JkVersionedModule versionedModule, String timestamp) {
        JkMavenMetadata metadata = new JkMavenMetadata();
        metadata.groupId = versionedModule.getModuleId().getGroup();
        metadata.artifactId = versionedModule.getModuleId().getName();
        metadata.modelVersion = "1.1.0";
        metadata.version = versionedModule.getVersion().getValue();
        metadata.versioning = new Versioning();
        metadata.versioning.snapshot = new Versioning.JkSnapshot(timestamp, 0);
        return metadata;
    }

    public static JkMavenMetadata of(JkModuleId moduleId) {
        JkMavenMetadata metadata = new JkMavenMetadata();
        metadata.groupId = moduleId.getGroup();
        metadata.artifactId = moduleId.getName();
        metadata.modelVersion = "1.1.0";
        return metadata;
    }

    public static JkMavenMetadata of(InputStream inputStream) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            Element metadata = (Element)doc.getElementsByTagName("metadata").item(0);
            String modelVersion = metadata.getAttribute("modelVersion");
            JkMavenMetadata result = new JkMavenMetadata();
            result.modelVersion = modelVersion;
            result.groupId = JkMavenMetadata.subValue(metadata, "groupId");
            result.artifactId = JkMavenMetadata.subValue(metadata, "artifactId");
            result.version = JkMavenMetadata.subValue(metadata, "version");
            Element versioningEl = (Element)metadata.getElementsByTagName("versioning").item(0);
            result.versioning = new Versioning(versioningEl);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JkMavenMetadata() {
    }

    public void updateSnapshot(String timestamp) {
        if (this.versioning == null) {
            this.versioning = new Versioning();
        }
        int buildNumber = this.versioning.currentBuildNumber() + 1;
        this.versioning.snapshot = new Versioning.JkSnapshot(timestamp, buildNumber);
        this.versioning.lastUpdate = timestamp.replace(".", "");
        this.versioning.snapshotVersions.clear();
    }

    public Versioning.JkSnapshot currentSnapshot() {
        return this.versioning.snapshot;
    }

    void setFirstCurrentSnapshot(String timestamp) {
        this.versioning.snapshot = new Versioning.JkSnapshot(timestamp, 1);
    }

    public void addSnapshotVersion(String extension, String classifier) {
        Versioning.SnapshotVersion snapshotVersion = new Versioning.SnapshotVersion();
        snapshotVersion.classifier = "".equals(classifier) ? null : classifier;
        snapshotVersion.extension = extension;
        snapshotVersion.updated = this.versioning.lastUpdate;
        String version = this.version.replace("-SNAPSHOT", "");
        Versioning.JkSnapshot snapshot = this.versioning.snapshot;
        snapshotVersion.value = version + "-" + snapshot.timestamp + "-" + snapshot.buildNumber;
        this.versioning.snapshotVersions.add(snapshotVersion);
    }

    public int currentBuildNumber() {
        return this.versioning.currentBuildNumber();
    }

    public void addVersion(String version, String timestamp) {
        if (!this.versioning.versions.contains(version)) {
            this.versioning.versions.add(version);
            Collections.sort(this.versioning.versions);
            this.versioning.latest = version;
            if (!version.endsWith("-SNAPSHOT")) {
                this.versioning.release = version;
            }
        }
        this.versioning.lastUpdate = timestamp;
    }

    public void output(OutputStream outputStream) {
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            this.write(writer);
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    private void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("metadata");
        writer.writeAttribute("modelVersion", this.modelVersion);
        JkMavenMetadata.ln(writer);
        JkMavenMetadata.indent(writer, 2);
        JkMavenMetadata.writeElement(writer, "groupId", this.groupId);
        JkMavenMetadata.ln(writer);
        JkMavenMetadata.indent(writer, 2);
        JkMavenMetadata.writeElement(writer, "artifactId", this.artifactId);
        JkMavenMetadata.ln(writer);
        JkMavenMetadata.indent(writer, 2);
        if (this.version != null) {
            JkMavenMetadata.writeElement(writer, "version", this.version);
            JkMavenMetadata.ln(writer);
            JkMavenMetadata.indent(writer, 2);
        }
        this.versioning.write(writer);
        JkMavenMetadata.ln(writer);
        writer.writeEndElement();
    }

    private static String subValue(Element el, String subTag) {
        NodeList nodeList = el.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(subTag)) continue;
            return element.getTextContent();
        }
        return null;
    }

    private static void writeElement(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    private static void ln(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n");
    }

    private static void indent(XMLStreamWriter writer, int deep) throws XMLStreamException {
        writer.writeCharacters(JkUtilsString.repeat(" ", deep));
    }

    public String lastUpdateTimestamp() {
        return this.versioning.lastUpdate;
    }

    public static class Versioning {
        private JkSnapshot snapshot;
        private String latest;
        private String release;
        private List<SnapshotVersion> snapshotVersions = new LinkedList<SnapshotVersion>();
        private String lastUpdate;
        private final List<String> versions = new LinkedList<String>();

        private Versioning() {
        }

        private Versioning(Element element) {
            NodeList snapshotVersionsNodeList;
            NodeList snapNodeList = element.getElementsByTagName("snapshot");
            if (snapNodeList.getLength() > 0) {
                this.snapshot = new JkSnapshot((Element)snapNodeList.item(0));
            }
            this.snapshotVersions = new LinkedList<SnapshotVersion>();
            NodeList versionsNodeList = element.getElementsByTagName("versions");
            if (versionsNodeList.getLength() > 0) {
                Element versions = (Element)element.getElementsByTagName("versions").item(0);
                NodeList nodeList = versions.getElementsByTagName("version");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element versionEl = (Element)nodeList.item(i);
                    this.versions.add(versionEl.getTextContent());
                }
            }
            if ((snapshotVersionsNodeList = element.getElementsByTagName("snapshotVersions")).getLength() > 0) {
                Element snapshotVersions = (Element)element.getElementsByTagName("snapshotVersions").item(0);
                NodeList nodeList = snapshotVersions.getElementsByTagName("snapshotVersion");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element snapshotVersionEl = (Element)nodeList.item(i);
                    this.snapshotVersions.add(new SnapshotVersion(snapshotVersionEl));
                }
            }
            this.latest = JkMavenMetadata.subValue(element, "latest");
            this.release = JkMavenMetadata.subValue(element, "release");
            this.lastUpdate = JkMavenMetadata.subValue(element, "lastUpdate");
        }

        private int currentBuildNumber() {
            if (this.snapshot == null) {
                return 0;
            }
            return this.snapshot.buildNumber;
        }

        private void write(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("versioning");
            if (this.latest != null) {
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 4);
                JkMavenMetadata.writeElement(writer, "latest", this.latest);
            }
            if (this.snapshot != null) {
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 4);
                this.snapshot.write(writer);
            }
            if (this.release != null) {
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 4);
                JkMavenMetadata.writeElement(writer, "release", this.release);
            }
            JkMavenMetadata.ln(writer);
            JkMavenMetadata.indent(writer, 4);
            if (!this.versions.isEmpty()) {
                writer.writeStartElement("versions");
                for (String version : this.versions) {
                    JkMavenMetadata.ln(writer);
                    JkMavenMetadata.indent(writer, 6);
                    JkMavenMetadata.writeElement(writer, "version", version);
                }
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 4);
                writer.writeEndElement();
            }
            if (!this.snapshotVersions.isEmpty()) {
                writer.writeStartElement("snapshotVersions");
                for (SnapshotVersion snapshotVersion : this.snapshotVersions) {
                    JkMavenMetadata.ln(writer);
                    JkMavenMetadata.indent(writer, 6);
                    snapshotVersion.write(writer);
                }
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 4);
                writer.writeEndElement();
            }
            JkMavenMetadata.ln(writer);
            JkMavenMetadata.indent(writer, 4);
            JkMavenMetadata.writeElement(writer, "lastUpdate", this.lastUpdate);
            JkMavenMetadata.ln(writer);
            JkMavenMetadata.indent(writer, 2);
            writer.writeEndElement();
        }

        private static class SnapshotVersion {
            String classifier;
            String extension;
            String value;
            String updated;

            private SnapshotVersion() {
            }

            SnapshotVersion(Element element) {
                this.classifier = JkMavenMetadata.subValue(element, "classifier");
                this.extension = JkMavenMetadata.subValue(element, "getExtension");
                this.updated = JkMavenMetadata.subValue(element, "updated");
                this.value = JkMavenMetadata.subValue(element, "value");
            }

            void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement("snapshotVersion");
                if (this.classifier != null) {
                    JkMavenMetadata.ln(writer);
                    JkMavenMetadata.indent(writer, 8);
                    JkMavenMetadata.writeElement(writer, "classifier", this.classifier);
                }
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 8);
                JkMavenMetadata.writeElement(writer, "getExtension", this.extension);
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 8);
                JkMavenMetadata.writeElement(writer, "updated", this.updated);
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 8);
                JkMavenMetadata.writeElement(writer, "value", this.value);
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 6);
                writer.writeEndElement();
            }
        }

        public static class JkSnapshot {
            public final String timestamp;
            public final int buildNumber;

            JkSnapshot(String timestamp, int buildNumber) {
                this.buildNumber = buildNumber;
                this.timestamp = timestamp;
            }

            JkSnapshot(Element element) {
                this.buildNumber = Integer.parseInt(JkMavenMetadata.subValue(element, "buildNumber"));
                this.timestamp = JkMavenMetadata.subValue(element, "timestamp");
            }

            void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement("snapshot");
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 6);
                JkMavenMetadata.writeElement(writer, "timestamp", this.timestamp);
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 6);
                JkMavenMetadata.writeElement(writer, "buildNumber", Integer.toString(this.buildNumber));
                JkMavenMetadata.ln(writer);
                JkMavenMetadata.indent(writer, 4);
                writer.writeEndElement();
            }
        }
    }
}

