/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.publication;

import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsSystem;
import dev.jeka.core.api.utils.JkUtilsXml;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JkNexusRepos {
    private static final long CLOSE_TIMEOUT_MILLIS = 900000L;
    private static final long CLOSE_WAIT_INTERVAL_MILLIS = 10000L;
    private final String baseUrl;
    private final String basicCredential;

    private JkNexusRepos(String baseUrl, String basicCredential) {
        this.baseUrl = baseUrl;
        this.basicCredential = basicCredential;
    }

    private static JkNexusRepos ofBasicCredentials(String baseUrl, String userName, String password) {
        byte[] basicCredential = Base64.getEncoder().encode((userName + ":" + password).getBytes(StandardCharsets.UTF_8));
        return new JkNexusRepos(baseUrl, new String(basicCredential));
    }

    public static JkNexusRepos ofUrlAndCredentials(JkRepo repo) {
        JkRepo.JkRepoCredentials repoCredentials = repo.getCredentials();
        URL url = repo.getUrl();
        String baseUrl = url.getProtocol() + "://" + url.getHost();
        return JkNexusRepos.ofBasicCredentials(baseUrl, repoCredentials.getUserName(), repoCredentials.getPassword());
    }

    public void closeAndReleaseOpenRepositories(String ... profileNames) {
        JkLog.startTask("Closing and releasing staged repositories", new Object[0]);
        List<JkStagingRepo> stagingRepos = this.findStagingRepositories();
        JkLog.info("Found staging repositories : ", new Object[0]);
        stagingRepos.forEach(repo -> JkLog.info(repo.toString(), new Object[0]));
        List<String> openRepoIds = stagingRepos.stream().filter(JkNexusRepos.profileNameFilter(profileNames)).filter(repo -> JkStagingRepo.Status.OPEN == repo.getStatus()).map(JkStagingRepo::getId).collect(Collectors.toList());
        if (profileNames.length != 0) {
            JkLog.info("Taking in account repositories with profile name in " + Arrays.asList(profileNames), new Object[0]);
        }
        JkLog.info("Repositories to close and release : " + openRepoIds, new Object[0]);
        this.close(openRepoIds);
        openRepoIds.forEach(this::waitForClosing);
        this.release(openRepoIds);
        JkLog.endTask();
    }

    public void closeAndRelease(String ... profileNames) {
        JkLog.startTask("Closing and releasing staged repository", new Object[0]);
        List<JkStagingRepo> stagingRepos = this.findStagingRepositories();
        JkLog.info("Found staging repositories : ", new Object[0]);
        stagingRepos.forEach(repo -> JkLog.info(repo.toString(), new Object[0]));
        List<String> openRepoIds = stagingRepos.stream().filter(JkNexusRepos.profileNameFilter(profileNames)).filter(repo -> JkStagingRepo.Status.OPEN == repo.getStatus()).map(JkStagingRepo::getId).collect(Collectors.toList());
        if (profileNames.length != 0) {
            JkLog.info("Taking in account repositories with profile name in " + Arrays.asList(profileNames), new Object[0]);
        }
        JkLog.info("Repositories to close : " + openRepoIds, new Object[0]);
        this.close(openRepoIds);
        List<String> closingRepoIds = this.findStagingRepositories().stream().filter(JkNexusRepos.profileNameFilter(profileNames)).filter(repo -> JkStagingRepo.Status.CLOSING == repo.getStatus()).map(JkStagingRepo::getId).collect(Collectors.toList());
        JkLog.info("Repositories to wait for been closed : " + closingRepoIds, new Object[0]);
        closingRepoIds.forEach(this::waitForClosing);
        List<String> closedRepoIds = this.findStagingRepositories().stream().filter(JkNexusRepos.profileNameFilter(profileNames)).filter(repo -> JkStagingRepo.Status.CLOSED == repo.getStatus()).map(JkStagingRepo::getId).collect(Collectors.toList());
        JkLog.info("Repositories to release : " + closedRepoIds, new Object[0]);
        this.release(closedRepoIds);
        JkLog.endTask();
    }

    public List<JkStagingRepo> findStagingRepositories() {
        try {
            return this.doFindStagingRepositories();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close(List<String> repositoryIds) {
        try {
            this.doClose(repositoryIds);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void waitForClosing(String repositoryId) {
        try {
            this.doWaitForClosing(repositoryId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void release(List<String> repositoryIds) {
        try {
            this.doRelease(repositoryIds);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<JkStagingRepo> doFindStagingRepositories() throws IOException {
        URL url = new URL(this.baseUrl + "/service/local/staging/profile_repositories");
        HttpURLConnection con = this.connection(url);
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "application/xml");
        this.assertResponseOk(con, null);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            Document doc = JkUtilsXml.documentFrom(in);
            Element data = JkUtilsXml.directChild(doc.getDocumentElement(), "data");
            List<Element> stagingReposEl = JkUtilsXml.directChildren(data, "stagingProfileRepository");
            List<JkStagingRepo> list = stagingReposEl.stream().map(x$0 -> JkStagingRepo.fromEl(x$0)).collect(Collectors.toList());
            return list;
        }
    }

    private JkStagingRepo doGetRepository(String repositoryId) throws IOException {
        URL url = new URL(this.baseUrl + "/service/local/staging/repository/" + repositoryId);
        HttpURLConnection con = this.connection(url);
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "application/xml");
        this.assertResponseOk(con, null);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            Document doc = JkUtilsXml.documentFrom(in);
            Element root = doc.getDocumentElement();
            JkStagingRepo jkStagingRepo = JkStagingRepo.fromEl(root);
            return jkStagingRepo;
        }
    }

    private void doClose(List<String> repositoryIds) throws IOException {
        if (repositoryIds.isEmpty()) {
            JkLog.info("No staging repository to close.", new Object[0]);
            return;
        }
        JkLog.startTask("Closing repositories " + repositoryIds, new Object[0]);
        URL url = new URL(this.baseUrl + "/service/local/staging/bulk/close");
        HttpURLConnection con = this.connection(url);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setDoOutput(true);
        String json = "{\"data\":{\"stagedRepositoryIds\":" + this.toJsonArray(repositoryIds) + "}}";
        try (OutputStream os = con.getOutputStream();){
            byte[] input = json.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        this.assertResponseOk(con, json);
        JkLog.endTask();
    }

    private void doRelease(List<String> repositoryIds) throws IOException {
        JkLog.startTask("Releasing repositories " + repositoryIds, new Object[0]);
        URL url = new URL(this.baseUrl + "/service/local/staging/bulk/promote");
        HttpURLConnection con = this.connection(url);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setDoOutput(true);
        String json = "{\"data\":{\"autoDropAfterRelease\":true,\"stagedRepositoryIds\":" + this.toJsonArray(repositoryIds) + "}}";
        try (OutputStream os = con.getOutputStream();){
            byte[] input = json.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        this.assertResponseOk(con, json);
        JkLog.endTask();
    }

    private void doWaitForClosing(String repositoryId) throws IOException {
        JkStagingRepo repo;
        long startMillis = System.currentTimeMillis();
        JkLog.startTask("Waiting for repository " + repositoryId + " been closed. It make take a while ...", new Object[0]);
        do {
            if (System.currentTimeMillis() - startMillis > 900000L) {
                throw new IllegalStateException("Timeout waiting for repository close.");
            }
            JkUtilsSystem.sleep(10000L);
        } while (!"closed".equals((repo = this.doGetRepository(repositoryId)).type) || repo.transitioning);
        JkLog.endTask();
    }

    private static Predicate<JkStagingRepo> profileNameFilter(String ... profileNames) {
        if (profileNames.length == 0) {
            return repo -> true;
        }
        return repo -> Arrays.asList(profileNames).contains(((JkStagingRepo)repo).profileName);
    }

    private HttpURLConnection connection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("Authorization", "basic " + this.basicCredential);
        con.setReadTimeout(5000);
        con.setInstanceFollowRedirects(true);
        return con;
    }

    private void assertResponseOk(HttpURLConnection con, String body) throws IOException {
        int code = con.getResponseCode();
        if (code >= 400) {
            InputStream inputStream = con.getErrorStream();
            if (inputStream == null) {
                throw new IllegalStateException("Request " + con.getRequestMethod() + " " + con.getURL() + " failed with status code " + code + "\nRequest body : " + body);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getErrorStream(), "utf-8"));
            Throwable throwable = null;
            try {
                try {
                    StringBuilder response = new StringBuilder();
                    String responseLine = null;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    throw new IllegalStateException("Request " + con.getURL() + " failed with status code " + code + "\nRequest body : " + body + "\nResponse body : " + response);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        br.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    private String toJsonArray(List<String> items) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<String> it = items.iterator();
        while (it.hasNext()) {
            sb.append("\"").append((Object)it.next()).append("\"");
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class JkStagingRepo {
        private final String id;
        private final long updatedTimestamp;
        private final String url;
        private final String type;
        private final boolean transitioning;
        private final String profileName;

        private JkStagingRepo(String id, long updatedTimestamp, String url, String type, boolean transitioning, String profileName) {
            this.id = id;
            this.updatedTimestamp = updatedTimestamp;
            this.url = url;
            this.type = type;
            this.transitioning = transitioning;
            this.profileName = profileName;
        }

        private static JkStagingRepo fromEl(Element el) {
            return new JkStagingRepo(JkUtilsXml.directChildText(el, "repositoryId"), Long.valueOf(JkUtilsXml.directChildText(el, "updatedTimestamp")), JkUtilsXml.directChildText(el, "repositoryURI"), JkUtilsXml.directChildText(el, "type"), Boolean.valueOf(JkUtilsXml.directChildText(el, "transitioning")), JkUtilsXml.directChildText(el, "profileName"));
        }

        public Status getStatus() {
            if ("open".equals(this.type)) {
                return this.transitioning ? Status.CLOSING : Status.OPEN;
            }
            return Status.CLOSED;
        }

        public String getId() {
            return this.id;
        }

        public long getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public String getUrl() {
            return this.url;
        }

        public String getType() {
            return this.type;
        }

        public boolean isTransitioning() {
            return this.transitioning;
        }

        public String getProfileName() {
            return this.profileName;
        }

        public String toString() {
            return "JkStagingRepo{id='" + this.id + '\'' + ", updatedTimestamp=" + this.updatedTimestamp + ", url='" + this.url + '\'' + ", type='" + this.type + '\'' + ", transitioning=" + this.transitioning + ", profileName='" + this.profileName + '\'' + '}';
        }

        static enum Status {
            OPEN,
            CLOSING,
            CLOSED;

        }
    }
}

