/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.publication;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class JkPomMetadata<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final T __;
    private String projectName;
    private String projectDescription;
    private String projectUrl;
    private String scmConnection;
    private String scmDeveloperConnection;
    private String scmUrl;
    private final List<JkDeveloperInfo> developers;
    private final List<JkLicenseInfo> licenses;

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public JkPomMetadata<T> setProjectName(String name) {
        this.projectName = name;
        return this;
    }

    public JkPomMetadata<T> setProjectDescription(String description) {
        this.projectDescription = description;
        return this;
    }

    public JkPomMetadata<T> setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
        return this;
    }

    public JkPomMetadata<T> setScmConnection(String scmConnection) {
        this.scmConnection = scmConnection;
        return this;
    }

    public JkPomMetadata<T> setScmDeveloperConnection(String scmDeveloperConnection) {
        this.scmDeveloperConnection = scmDeveloperConnection;
        return this;
    }

    public JkPomMetadata<T> setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
        return this;
    }

    public String getScmConnection() {
        return this.scmConnection;
    }

    public String getScmDeveloperConnection() {
        return this.scmDeveloperConnection;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    private JkPomMetadata(T parent) {
        this.__ = parent;
        this.developers = new LinkedList<JkDeveloperInfo>();
        this.licenses = new LinkedList<JkLicenseInfo>();
    }

    public static JkPomMetadata<Void> of() {
        return new JkPomMetadata<Object>(null);
    }

    public static <T> JkPomMetadata<T> ofParent(T parent) {
        return new JkPomMetadata<T>(parent);
    }

    public JkPomMetadata<T> addDeveloper(JkDeveloperInfo developerInfo) {
        this.developers.add(developerInfo);
        return this;
    }

    public JkPomMetadata<T> addDeveloper(String name, String email, String organisation, String organisationUrl) {
        return this.addDeveloper(new JkDeveloperInfo(name, email, organisation, organisationUrl));
    }

    public JkPomMetadata<T> addGithubDeveloper(String name, String email) {
        return this.addDeveloper(new JkDeveloperInfo(name, email, "Github", "https://github.com"));
    }

    public JkPomMetadata<T> addLicense(JkLicenseInfo licenseInfo) {
        this.licenses.add(licenseInfo);
        return this;
    }

    public JkPomMetadata<T> addLicense(String name, String url) {
        this.licenses.add(JkLicenseInfo.of(name, url));
        return this;
    }

    public JkPomMetadata<T> addApache2License() {
        return this.addLicense("Apache License V2.0", "http://www.apache.org/licenses/LICENSE-2.0.html");
    }

    public JkPomMetadata<T> addGpl3License() {
        return this.addLicense("GNU General public license V3", "https://www.gnu.org/copyleft/gpl.html");
    }

    public JkPomMetadata<T> addMitLicense() {
        return this.addLicense("MIT License", "http://opensource.org/licenses/MIT");
    }

    public List<JkDeveloperInfo> getDevelopers() {
        return Collections.unmodifiableList(this.developers);
    }

    public List<JkLicenseInfo> getLicenses() {
        return Collections.unmodifiableList(this.licenses);
    }

    public static final class JkLicenseInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String url;

        private JkLicenseInfo(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public static JkLicenseInfo of(String name, String url) {
            return new JkLicenseInfo(name, url);
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static final class JkDeveloperInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String email;
        private final String organisation;
        private final String organisationUrl;

        JkDeveloperInfo(String name, String email, String organisation, String organisationUrl) {
            this.name = name;
            this.email = email;
            this.organisation = organisation;
            this.organisationUrl = organisationUrl;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public String getOrganisation() {
            return this.organisation;
        }

        public String getOrganisationUrl() {
            return this.organisationUrl;
        }
    }
}

