/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.publication;

import dev.jeka.core.api.depmanagement.publication.JkPomMetadata;
import dev.jeka.core.api.system.JkInfo;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.StringWriter;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class JkPomTemplateGenerator {
    private static final String TOKEN = "____jeka.maven.extraInfo____";
    private static final String VERSION_TOKEN = "____jekaVersion____";

    public static Path generateTemplate(JkPomMetadata publicationInfo) {
        String extraXml;
        String firstTemplate = JkUtilsIO.read(JkPomTemplateGenerator.class.getResource("pom-full.template"));
        try {
            extraXml = JkPomTemplateGenerator.extraXml(publicationInfo);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        String completeTemplate = firstTemplate.replace(TOKEN, extraXml);
        String JekaVersion = JkUtilsObject.firstNonNull(JkInfo.getJekaVersion(), "Development version");
        completeTemplate = completeTemplate.replace(VERSION_TOKEN, JekaVersion);
        Path result = JkUtilsPath.createTempFile("jeka-pom", ".template", new FileAttribute[0]);
        JkUtilsPath.write(result, completeTemplate.getBytes(), new OpenOption[0]);
        return result;
    }

    private static String extraXml(JkPomMetadata publicationInfo) throws XMLStreamException, FactoryConfigurationError {
        List<JkPomMetadata.JkDeveloperInfo> developers;
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
        JkPomTemplateGenerator.writeElement("  ", writer, "name", publicationInfo.getProjectName());
        JkPomTemplateGenerator.writeElement("  ", writer, "description", publicationInfo.getProjectDescription());
        JkPomTemplateGenerator.writeElement("  ", writer, "url", publicationInfo.getProjectUrl());
        List<JkPomMetadata.JkLicenseInfo> licenses = publicationInfo.getLicenses();
        if (!licenses.isEmpty()) {
            writer.writeCharacters("\n");
            writer.writeCharacters("  ");
            writer.writeStartElement("licenses");
            for (JkPomMetadata.JkLicenseInfo license : licenses) {
                writer.writeCharacters("\n    ");
                writer.writeStartElement("license");
                writer.writeCharacters("\n");
                JkPomTemplateGenerator.writeElement("      ", writer, "name", license.getName());
                JkPomTemplateGenerator.writeElement("      ", writer, "url", license.getUrl());
                writer.writeCharacters("    ");
                writer.writeEndElement();
            }
            writer.writeCharacters("\n  ");
            writer.writeEndElement();
        }
        if (!(developers = publicationInfo.getDevelopers()).isEmpty()) {
            writer.writeCharacters("\n\n");
            writer.writeCharacters("  ");
            writer.writeStartElement("developers");
            for (JkPomMetadata.JkDeveloperInfo developer : developers) {
                writer.writeCharacters("\n    ");
                writer.writeStartElement("developer");
                writer.writeCharacters("\n");
                JkPomTemplateGenerator.writeElement("      ", writer, "name", developer.getName());
                JkPomTemplateGenerator.writeElement("      ", writer, "email", developer.getEmail());
                JkPomTemplateGenerator.writeElement("      ", writer, "organization", developer.getOrganisation());
                JkPomTemplateGenerator.writeElement("      ", writer, "organizationUrl", developer.getOrganisationUrl());
                writer.writeCharacters("    ");
                writer.writeEndElement();
            }
            writer.writeCharacters("\n  ");
            writer.writeEndElement();
        }
        writer.writeCharacters("\n\n  ");
        writer.writeStartElement("scm");
        writer.writeCharacters("\n");
        JkPomTemplateGenerator.writeElement("    ", writer, "connection", publicationInfo.getScmConnection());
        JkPomTemplateGenerator.writeElement("    ", writer, "developerConnection", publicationInfo.getScmDeveloperConnection());
        JkPomTemplateGenerator.writeElement("    ", writer, "url", publicationInfo.getProjectUrl());
        writer.writeCharacters("  ");
        writer.writeEndElement();
        writer.flush();
        writer.close();
        return stringWriter.toString();
    }

    private static void writeElement(XMLStreamWriter writer, String elementName, String text) throws XMLStreamException {
        if (text == null) {
            return;
        }
        writer.writeStartElement(elementName);
        writer.writeCharacters(text);
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private static void writeElement(String indent, XMLStreamWriter writer, String elementName, String text) throws XMLStreamException {
        if (text == null) {
            return;
        }
        writer.writeCharacters(indent);
        JkPomTemplateGenerator.writeElement(writer, elementName, text);
    }
}

