/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.resolution;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.resolution.JkResolutionParameters;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.file.JkUrlFileProxy;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkInternalClassloader;
import dev.jeka.core.api.utils.JkUtilsReflect;
import java.io.File;
import java.util.List;

public interface JkInternalDependencyResolver {
    default public JkResolveResult resolve(JkVersionedModule module, JkDependencySet deps, JkResolutionParameters parameters) {
        List<JkDependency> depList = deps.normalised(JkVersionedModule.ConflictStrategy.FAIL).getVersionedDependencies();
        return this.resolve(module, JkQualifiedDependencySet.ofDependencies(depList).withGlobalExclusions(deps.getGlobalExclusions()), parameters);
    }

    public JkResolveResult resolve(JkVersionedModule var1, JkQualifiedDependencySet var2, JkResolutionParameters var3);

    public File get(JkModuleDependency var1);

    public List<String> searchGroups();

    public List<String> searchModules(String var1);

    public List<String> searchVersions(JkModuleId var1);

    public static JkInternalDependencyResolver of(JkRepoSet repos) {
        String factoryClassName = "dev.jeka.core.api.depmanagement.embedded.ivy.IvyInternalDepResolverFactory";
        Class factoryClass = JkClassLoader.ofCurrent().loadIfExist("dev.jeka.core.api.depmanagement.embedded.ivy.IvyInternalDepResolverFactory");
        if (factoryClass != null) {
            return (JkInternalDependencyResolver)JkUtilsReflect.invokeStaticMethod(factoryClass, "of", repos);
        }
        return InternalVvyClassloader.get().createCrossClassloaderProxy(JkInternalDependencyResolver.class, "dev.jeka.core.api.depmanagement.embedded.ivy.IvyInternalDepResolverFactory", "of", repos);
    }

    public static class InternalVvyClassloader {
        private static JkInternalClassloader IVY_CLASSLOADER;

        public static JkInternalClassloader get() {
            if (IVY_CLASSLOADER != null) {
                return IVY_CLASSLOADER;
            }
            JkUrlFileProxy fileProxy = JkUrlFileProxy.of("https://repo1.maven.org/maven2/org/apache/ivy/ivy/2.5.0/ivy-2.5.0.jar", JkModuleDependency.of("org.apache.ivy:ivy:2.5.0").cachePath());
            IVY_CLASSLOADER = JkInternalClassloader.ofMainEmbeddedLibs(fileProxy.get());
            return IVY_CLASSLOADER;
        }
    }
}

