/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.resolution;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;

public class JkModuleDepProblem {
    private final JkModuleId moduleId;
    private final JkVersion version;
    private final String problemText;

    private JkModuleDepProblem(JkModuleId moduleId, JkVersion version, String problemText) {
        this.moduleId = moduleId;
        this.version = version;
        this.problemText = problemText;
    }

    public static JkModuleDepProblem of(JkModuleId moduleId, String version, String text) {
        return new JkModuleDepProblem(moduleId, JkVersion.of(version), text);
    }

    public static JkModuleDepProblem of(JkVersionedModule versionedModule, String text) {
        return JkModuleDepProblem.of(versionedModule.getModuleId(), versionedModule.getVersion().getValue(), text);
    }

    public JkModuleId getModuleId() {
        return this.moduleId;
    }

    public JkVersion getVersion() {
        return this.version;
    }

    public String getProblemText() {
        return this.problemText;
    }

    public String toString() {
        return this.moduleId + ":" + this.version + " -> " + this.problemText;
    }
}

