/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.resolution;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.resolution.JkModuleDepProblem;
import dev.jeka.core.api.depmanagement.resolution.JkResolvedDependencyNode;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.utils.JkUtilsIterable;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;

public final class JkResolveResult {
    private final JkResolvedDependencyNode depTree;
    private final JkErrorReport errorReport;

    private JkResolveResult(JkResolvedDependencyNode depTree, JkErrorReport errorReport) {
        this.depTree = depTree;
        this.errorReport = errorReport;
    }

    static JkResolveResult ofRoot(JkVersionedModule module) {
        JkResolvedDependencyNode.JkModuleNodeInfo nodeInfo = module == null ? JkResolvedDependencyNode.JkModuleNodeInfo.ofAnonymousRoot() : JkResolvedDependencyNode.JkModuleNodeInfo.ofRoot(module);
        return JkResolveResult.of(JkResolvedDependencyNode.ofEmpty(nodeInfo));
    }

    public static JkResolveResult of(JkResolvedDependencyNode depTree, JkErrorReport errorReport) {
        return new JkResolveResult(depTree, errorReport);
    }

    private static JkResolveResult of(JkResolvedDependencyNode dependencyTree) {
        return new JkResolveResult(dependencyTree, JkErrorReport.allFine());
    }

    public JkPathSequence getFiles() {
        return JkPathSequence.of(this.depTree.getResolvedFiles()).withoutDuplicates().resolvedTo(Paths.get("", new String[0]));
    }

    public boolean contains(JkModuleId moduleId) {
        return this.depTree.contains(moduleId);
    }

    public JkVersion getVersionOf(JkModuleId moduleId) {
        return this.getResolvedVersionProvider().getVersionOf(moduleId);
    }

    public Set<JkVersionedModule> getInvolvedModules() {
        return this.depTree.getChildModules();
    }

    public JkVersionProvider getResolvedVersionProvider() {
        return this.depTree.getResolvedVersions();
    }

    public JkPathSequence getFilesFor(JkModuleId moduleId) {
        JkResolvedDependencyNode dependencyNode = this.depTree.getFirst(moduleId);
        if (dependencyNode == null) {
            return JkPathSequence.of();
        }
        return JkPathSequence.of(dependencyNode.getModuleInfo().getFiles()).withoutDuplicates();
    }

    public JkResolveResult and(JkResolveResult other) {
        return new JkResolveResult(this.depTree.withMerging(other.depTree), this.errorReport.merge(other.errorReport));
    }

    JkResolveResult withBaseDir(Path baseDir) {
        return new JkResolveResult(this.depTree, this.errorReport);
    }

    public JkResolvedDependencyNode getDependencyTree() {
        return this.depTree;
    }

    public JkErrorReport getErrorReport() {
        return this.errorReport;
    }

    public JkResolveResult assertNoError() {
        if (this.errorReport.hasErrors) {
            throw new IllegalStateException(this.errorReport + "\nOn following tree : \n" + this.depTree.toStringTree());
        }
        return this;
    }

    public static class JkErrorReport
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<JkModuleDepProblem> moduleProblems;
        private final boolean hasErrors;

        public static JkErrorReport allFine() {
            return new JkErrorReport(JkUtilsIterable.listOf(new JkModuleDepProblem[0]), false);
        }

        public static JkErrorReport failure(List<JkModuleDepProblem> missingArtifacts) {
            return new JkErrorReport(missingArtifacts, true);
        }

        private JkErrorReport(List<JkModuleDepProblem> dependencies, boolean hasErrors) {
            this.moduleProblems = dependencies;
            this.hasErrors = hasErrors || !this.moduleProblems.isEmpty();
        }

        public List<JkModuleDepProblem> getModuleProblems() {
            return this.moduleProblems;
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        private JkErrorReport merge(JkErrorReport other) {
            return new JkErrorReport(JkUtilsIterable.concatLists(this.moduleProblems, other.moduleProblems), this.hasErrors || other.hasErrors);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.moduleProblems.isEmpty()) {
                sb.append("Errors with dependencies : ").append(this.moduleProblems);
            }
            return sb.toString();
        }
    }
}

