/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JkPathFile {
    private final Path path;

    private JkPathFile(Path path) {
        this.path = path;
    }

    public static JkPathFile of(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path + " is a directory");
        }
        return new JkPathFile(path);
    }

    public static JkPathFile of(String path) {
        return JkPathFile.of(Paths.get(path, new String[0]));
    }

    public static JkPathFile of(URL url) {
        try {
            return JkPathFile.of(Paths.get(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Path get() {
        return this.path;
    }

    public JkPathFile createIfNotExist() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            if (this.path.getParent() != null) {
                JkUtilsPath.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            JkUtilsPath.createFile(this.path, new FileAttribute[0]);
        }
        return this;
    }

    public JkPathFile copyReplacingTokens(Path to, Map<String, String> tokens, Charset charset) {
        JkPathFile.of(to).createIfNotExist();
        if (tokens.isEmpty()) {
            JkUtilsPath.copy(this.path, to, StandardCopyOption.REPLACE_EXISTING);
            return this;
        }
        try (Stream<String> stream = Files.lines(this.path, charset);){
            List result = stream.map(line -> JkPathFile.interpolated(line, tokens)).collect(Collectors.toList());
            Files.write(to, result, charset, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public JkPathFile copyToDir(Path dir, CopyOption ... options) {
        Path target = dir.resolve(this.path.getFileName());
        if (!Files.exists(dir, new LinkOption[0])) {
            JkUtilsPath.createDirectories(dir, new FileAttribute[0]);
        }
        JkUtilsPath.copy(this.path, target, options);
        return this;
    }

    public JkPathFile move(Path to, CopyOption ... options) {
        try {
            Files.move(this.path, to, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public JkPathFile fetchContentFrom(URL url) {
        this.createIfNotExist();
        JkUtilsIO.copyUrlToFile(url, this.path);
        return this;
    }

    public JkPathFile fetchContentFrom(String urlString) {
        return this.fetchContentFrom(JkUtilsIO.toUrl(urlString));
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public JkPathFile deleteIfExist() {
        if (this.exists()) {
            JkUtilsPath.deleteFile(this.path);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getChecksum(String algorithm) {
        this.assertExist();
        try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
            int len;
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.reset();
            byte[] buf = new byte[2048];
            while ((len = is.read(buf)) != -1) {
                md.update(buf, 0, len);
            }
            byte[] bytes = md.digest();
            String string = JkUtilsString.toHexString(bytes);
            return string;
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    public JkPathFile write(byte[] bytes, OpenOption ... options) {
        JkUtilsPath.write(this.path, bytes, options);
        return this;
    }

    public JkPathFile checksum(String ... algorithms) {
        this.assertExist();
        for (String algorithm : algorithms) {
            String fileName = this.path.getFileName().toString() + "." + algorithm.toLowerCase();
            JkPathFile.of(this.path.resolveSibling(fileName)).deleteIfExist().write(this.getChecksum(algorithm).getBytes(Charset.forName("ASCII")), new OpenOption[0]);
        }
        return this;
    }

    public JkPathFile setPosixExecPermissions(boolean owner, boolean group, boolean other) {
        this.assertExist();
        Set<PosixFilePermission> perms = null;
        try {
            perms = Files.getPosixFilePermissions(this.path, new LinkOption[0]);
            if (owner) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if (group) {
                perms.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if (other) {
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            Files.setPosixFilePermissions(this.path, perms);
        }
        catch (UnsupportedOperationException e) {
            JkLog.warn("Can not set POSIX permissions to file " + this.path, new Object[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public JkPathFile setPosixExecPermissions() {
        return this.setPosixExecPermissions(true, true, true);
    }

    private static String interpolated(String original, Map<String, String> tokenValues) {
        boolean changed = false;
        String result = original;
        for (Map.Entry<String, String> entry : tokenValues.entrySet()) {
            String newResult = result.replace(entry.getKey(), entry.getValue());
            if (newResult.equals(result)) continue;
            changed = true;
            result = newResult;
        }
        if (changed) {
            return JkPathFile.interpolated(result, tokenValues);
        }
        return result;
    }

    public void assertExist() {
        if (!this.exists()) {
            throw new IllegalStateException("File " + this.path.toAbsolutePath().normalize() + " does not exist.");
        }
    }

    public String getExtension() {
        String filename = this.path.getFileName().toString();
        int index = filename.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return filename.substring(index + 1);
    }

    public String toString() {
        return this.path.toString();
    }
}

