/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.utils.JkUtilsAssert;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;

public final class JkPathMatcher
implements PathMatcher {
    private static final String ALL_LABEL_PREFIX = "all && ";
    static final JkPathMatcher ACCEPT_ALL = JkPathMatcher.of();
    private final PathMatcher matcher;
    private final String label;

    public static JkPathMatcher of(PathMatcher matcher) {
        return new JkPathMatcher(matcher, "?");
    }

    public static JkPathMatcher of() {
        return new JkPathMatcher(path -> true, "all");
    }

    public static JkPathMatcher ofNoDirectory(LinkOption ... linkOptions) {
        return new JkPathMatcher(path -> {
            if (path.toString().equals("")) {
                return false;
            }
            return !Files.isDirectory(path, linkOptions);
        }, "No directories");
    }

    public static JkPathMatcher of(boolean positive, FileSystem fileSystem, String ... globPattern) {
        return JkPathMatcher.of(positive, fileSystem, Arrays.asList(globPattern));
    }

    public static JkPathMatcher of(String ... globPatterns) {
        return JkPathMatcher.of(true, globPatterns);
    }

    public static JkPathMatcher of(boolean positive, String ... globPattern) {
        return JkPathMatcher.of(positive, FileSystems.getDefault(), Arrays.asList(globPattern));
    }

    public static JkPathMatcher of(boolean positive, FileSystem fileSystem, Iterable<String> globPatterns) {
        Iterator<String> it = globPatterns.iterator();
        if (!it.hasNext()) {
            return JkPathMatcher.of();
        }
        String pattern = it.next();
        PathMatcher result = path -> positive == JkPathMatcher.globMatcher(fileSystem, pattern).matches(path);
        while (it.hasNext()) {
            String itPattern = it.next();
            if (positive) {
                result = new OrMatcher(result, JkPathMatcher.globMatcher(fileSystem, itPattern));
                continue;
            }
            result = new AndMatcher(result, path -> !JkPathMatcher.globMatcher(fileSystem, itPattern).matches(path));
        }
        String name = positive ? "in" : "out";
        return new JkPathMatcher(result, name + globPatterns);
    }

    private JkPathMatcher(PathMatcher matcher, String label) {
        this.matcher = matcher;
        this.label = label;
    }

    public String toString() {
        if (this.label.startsWith(ALL_LABEL_PREFIX)) {
            return this.label.substring(ALL_LABEL_PREFIX.length());
        }
        return this.label;
    }

    public Predicate<Path> toPredicate() {
        return path -> this.matcher.matches((Path)path);
    }

    @Override
    public boolean matches(Path path) {
        return this.matcher.matches(path);
    }

    public JkPathMatcher and(PathMatcher other) {
        if (this == ACCEPT_ALL) {
            if (other == JkPathMatcher.ACCEPT_ALL.matcher || other == ACCEPT_ALL) {
                return ACCEPT_ALL;
            }
            return new JkPathMatcher(other, other.toString());
        }
        if (other == JkPathMatcher.ACCEPT_ALL.matcher || other == ACCEPT_ALL) {
            return this;
        }
        return new JkPathMatcher(new AndMatcher(this.matcher, other), this.label + " && " + other.toString());
    }

    public JkPathMatcher or(PathMatcher other) {
        JkUtilsAssert.argument(other != null, "Combined path matcher cannot be null", new Object[0]);
        if (this == ACCEPT_ALL || other == ACCEPT_ALL || other == JkPathMatcher.ACCEPT_ALL.matcher) {
            return ACCEPT_ALL;
        }
        return new JkPathMatcher(new OrMatcher(this.matcher, other), this.label + " || " + other.toString());
    }

    public JkPathMatcher and(boolean positive, FileSystem fileSystem, String ... patterns) {
        return this.and(JkPathMatcher.of(positive, fileSystem, patterns));
    }

    public JkPathMatcher and(boolean positive, String ... patterns) {
        return this.and(positive, FileSystems.getDefault(), patterns);
    }

    private static PathMatcher globMatcher(FileSystem fileSystem, String pattern) {
        return fileSystem.getPathMatcher("glob:" + pattern);
    }

    public JkPathMatcher reversed() {
        PathMatcher reversedMatcher = path -> !this.matcher.matches(path);
        return new JkPathMatcher(reversedMatcher, "Reverse of " + this.label);
    }

    private static class OrMatcher
    implements PathMatcher {
        private final PathMatcher pathMatcher1;
        private final PathMatcher pathMatcher2;

        public OrMatcher(PathMatcher pathMatcher1, PathMatcher pathMatcher2) {
            this.pathMatcher1 = pathMatcher1;
            this.pathMatcher2 = pathMatcher2;
        }

        @Override
        public boolean matches(Path path) {
            return this.pathMatcher1.matches(path) || this.pathMatcher2.matches(path);
        }
    }

    private static class AndMatcher
    implements PathMatcher {
        private final PathMatcher pathMatcher1;
        private final PathMatcher pathMatcher2;

        public AndMatcher(PathMatcher pathMatcher1, PathMatcher pathMatcher2) {
            this.pathMatcher1 = pathMatcher1;
            this.pathMatcher2 = pathMatcher2;
        }

        @Override
        public boolean matches(Path path) {
            return this.pathMatcher1.matches(path) && this.pathMatcher2.matches(path);
        }
    }
}

