/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.function;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class JkRunnables<T>
implements Runnable {
    private final LinkedList<Entry> entries = new LinkedList();
    private boolean log;
    public final T __;

    public static JkRunnables<Void> of() {
        return JkRunnables.ofParent(null);
    }

    public static <T> JkRunnables<T> ofParent(T parent) {
        return new JkRunnables<T>(parent);
    }

    private JkRunnables(T parent) {
        this.__ = parent;
    }

    private JkRunnables<T> append(String name, Runnable runnable, Entry.RelativePlace relativePlace) {
        JkUtilsAssert.argument(!this.contains(name), "runnable container contains already an entry named '" + name + "'", new Object[0]);
        Entry entry = new Entry(name, runnable, relativePlace);
        this.entries.add(entry);
        Collections.sort(this.entries);
        return this;
    }

    public JkRunnables<T> append(String name, Runnable runnable) {
        return this.append(name, runnable, null);
    }

    public JkRunnables<T> append(Runnable runnable) {
        return this.append(runnable.toString(), runnable);
    }

    public JkRunnables<T> appendBefore(String name, String beforeRunnableName, Runnable runnable) {
        return this.append(name, runnable, new Entry.RelativePlace(beforeRunnableName, Entry.Where.BEFORE));
    }

    public JkRunnables<T> appendAfter(String name, String afterRunnableName, Runnable runnable) {
        return this.append(name, runnable, new Entry.RelativePlace(afterRunnableName, Entry.Where.AFTER));
    }

    public List<String> getRunnableNames() {
        return this.entries.stream().map(entry -> entry.name).collect(Collectors.toList());
    }

    public JkRunnables<T> remove(String runnableName) {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            if (!((Entry)it.next()).name.equals(runnableName)) continue;
            it.remove();
        }
        return this;
    }

    public boolean contains(String runnableName) {
        return this.entries.stream().anyMatch(entry -> entry.name.equals(runnableName));
    }

    @Override
    public void run() {
        this.entries.forEach(entry -> {
            if (this.log) {
                JkLog.startTask("running " + entry.name, new Object[0]);
            }
            entry.runnable.run();
            if (this.log) {
                JkLog.endTask();
            }
        });
    }

    public JkRunnables<T> setLogRunnableName(boolean log) {
        this.log = log;
        return this;
    }

    private static class Entry
    implements Comparable<Entry> {
        final String name;
        final Runnable runnable;
        final RelativePlace relativePlace;

        @Override
        public int compareTo(Entry other) {
            if (!this.hasRelationWith(other)) {
                return 0;
            }
            if (this.hasRelationConflictWith(other)) {
                throw new IllegalStateException("Entries " + this + " and " + other + " have relative position in conflict with each other.");
            }
            if (this.isRelativeTo(other.name)) {
                return this.relativePlace.where == Where.BEFORE ? -1 : 1;
            }
            return other.relativePlace.where == Where.BEFORE ? 1 : -1;
        }

        Entry(String name, Runnable runnable, RelativePlace relativePlace) {
            JkUtilsAssert.argument(name != null, "runnable name cannot be null", new Object[0]);
            JkUtilsAssert.argument(runnable != null, "runnable cannot be null", new Object[0]);
            this.name = name;
            this.runnable = runnable;
            this.relativePlace = relativePlace;
        }

        Entry(Runnable runnable) {
            this(runnable.toString(), runnable, null);
        }

        boolean isRelativeTo(String entryName) {
            return this.relativePlace != null && this.relativePlace.relativeEntryName.equals(entryName);
        }

        boolean hasRelationWith(Entry other) {
            return this.isRelativeTo(other.name) || other.isRelativeTo(this.name);
        }

        boolean hasRelationConflictWith(Entry other) {
            return this.isRelativeTo(other.name) && other.isRelativeTo(this.name) && this.relativePlace.where.equals((Object)other.relativePlace.where);
        }

        public String toString() {
            return this.name + (this.relativePlace == null ? "" : " (" + this.relativePlace + ")");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.name.equals(entry.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        static class RelativePlace {
            final String relativeEntryName;
            final Where where;

            public RelativePlace(String name, Where where) {
                JkUtilsAssert.argument(name != null, "relative runnable name cannot be null", new Object[0]);
                JkUtilsAssert.argument(where != null, "where position cannot be null", new Object[0]);
                this.relativeEntryName = name;
                this.where = where;
            }

            public String toString() {
                return (Object)((Object)this.where) + " " + this.relativeEntryName;
            }
        }

        static enum Where {
            BEFORE,
            AFTER;

        }
    }
}

