/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.java.JkInternalClasspathScanner;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class JkClassLoader {
    private final ClassLoader delegate;

    private JkClassLoader(ClassLoader delegate) {
        this.delegate = delegate;
    }

    public static JkClassLoader of(ClassLoader classLoader) {
        JkUtilsAssert.argument(classLoader != null, "Wrapped classloader cannot be null.", new Object[0]);
        return new JkClassLoader(classLoader);
    }

    public static JkClassLoader ofCurrent() {
        return JkClassLoader.of(Thread.currentThread().getContextClassLoader());
    }

    public static JkClassLoader ofLoaderOf(Class<?> clazz) {
        return JkClassLoader.of(clazz.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : clazz.getClassLoader());
    }

    public ClassLoader get() {
        return this.delegate;
    }

    public <T> Class<T> load(String className) {
        try {
            return this.delegate.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException("Fail at loading class " + className + " on " + this.delegate, e);
        }
    }

    public boolean isDefined(String className) {
        try {
            this.delegate.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public <T> Class<T> loadIfExist(String className) {
        try {
            return this.delegate.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public <T> Class<T> loadGivenClassSourcePath(String classSourcePath) {
        return this.load(JkClassLoader.classNameFromSourceFilePath(classSourcePath));
    }

    public <T> Class<T> loadGivenClassSourcePathIfExist(String classSourcePath) {
        return this.loadIfExist(JkClassLoader.classNameFromSourceFilePath(classSourcePath));
    }

    private static String classNameFromSourceFilePath(String sourcePath) {
        String dotName = sourcePath.replace('/', '.').replace('\\', '.');
        return JkUtilsString.substringBeforeLast(dotName, ".");
    }

    public boolean isDescendantOf(ClassLoader classLoader) {
        if (this.delegate.getParent() == null) {
            return false;
        }
        if (this.delegate.equals(classLoader)) {
            return true;
        }
        return JkClassLoader.of(this.delegate.getParent()).isDescendantOf(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invokeStaticMethod(boolean serializeResult, String className, String methodName, Object ... args) {
        Object[] effectiveArgs = this.crossClassloaderArgs(args);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.delegate);
        try {
            Object result;
            Class<T> clazz = this.load(className);
            Object returned = JkUtilsReflect.invokeStaticMethod(clazz, methodName, effectiveArgs);
            if (serializeResult) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                result = JkClassLoader.crossClassLoader(returned, currentClassLoader);
            } else {
                result = returned;
            }
            Object t = result;
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private Object[] crossClassloaderArgs(Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = JkClassLoader.crossClassLoader(args[i], this.delegate);
        }
        return result;
    }

    public <T> T instantiate(String className) {
        Class<T> clazz = this.load(className);
        return JkUtilsReflect.newInstance(clazz);
    }

    public String toString() {
        return JkClassLoader.toString(this.delegate);
    }

    private static String toString(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return JkClassLoader.ucltoString((URLClassLoader)classLoader);
        }
        StringBuilder result = new StringBuilder();
        result.append(classLoader).append("\n");
        JkInternalClasspathScanner.of().getClasspath(classLoader).forEach(path -> result.append("  ").append(path).append("  \n"));
        return result.toString();
    }

    private static String ucltoString(URLClassLoader urlClassLoader) {
        StringBuilder builder = new StringBuilder();
        builder.append(urlClassLoader);
        for (URL url : urlClassLoader.getURLs()) {
            builder.append("\n  ").append(url);
        }
        if (urlClassLoader.getParent() != null) {
            builder.append("\n").append(JkClassLoader.toString(urlClassLoader.getParent()));
        }
        return builder.toString();
    }

    private static Object crossClassLoader(Object object, ClassLoader to) {
        boolean container;
        if (object == null) {
            return null;
        }
        if (JkClassLoader.of(to).isDescendantOf(object.getClass().getClassLoader())) {
            return object;
        }
        Class<?> clazz = object.getClass();
        String className = clazz.isArray() ? object.getClass().getComponentType().getName() : object.getClass().getName();
        JkClassLoader from = JkClassLoader.ofLoaderOf(object.getClass());
        Class toClass = JkClassLoader.of(to).load(className);
        boolean bl = container = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
        if (from.delegate == null && !container) {
            return object;
        }
        if (toClass.equals(object.getClass()) && !container) {
            return object;
        }
        return JkUtilsIO.cloneBySerialization(object, to);
    }

    public <T> T invokeInstanceMethod(ClassLoader from, Object object, Method method, Object ... args) {
        Object[] effectiveArgs = this.crossClassloaderArgs(args);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.delegate);
        try {
            Object returned = JkUtilsReflect.invoke(object, method, effectiveArgs);
            Object result = from != null ? JkClassLoader.crossClassLoader(returned, from) : returned;
            Object v = result;
            return (T)v;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public List<String> findClassesHavingMainMethod() {
        return JkInternalClasspathScanner.of().findClassesHavingMainMethod(this.delegate);
    }

    public List<String> findClassesMatchingAnnotations(Predicate<List<String>> annotationNamePredicate) {
        return JkInternalClasspathScanner.of().findClassesMatchingAnnotations(this.delegate, annotationNamePredicate);
    }

    public JkPathSequence getClasspath() {
        return JkInternalClasspathScanner.of().getClasspath(this.delegate);
    }
}

