/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class JkInternalClassloader {
    private final ClassLoader classLoader;
    public static final Path URL_CACHE_DIR = JkLocator.getCacheDir().resolve("url-content");

    private JkInternalClassloader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static JkInternalClassloader of(ClassLoader classLoader) {
        return new JkInternalClassloader(classLoader);
    }

    public static JkInternalClassloader ofMainEmbeddedLibs(Path ... extraEntries) {
        return JkInternalClassloader.ofMainEmbeddedLibs(Arrays.asList(extraEntries));
    }

    public static JkInternalClassloader ofMainEmbeddedLibs(List<Path> extraEntries) {
        JkUtilsSystem.disableUnsafeWarning();
        LinkedList<Path> pathList = new LinkedList<Path>();
        URL embeddedNameUrl = JkClassLoader.ofCurrent().get().getResource("META-INF/jeka-embedded-name");
        if (embeddedNameUrl != null) {
            String jarName = JkUtilsIO.read(embeddedNameUrl);
            Path file = JkInternalClassloader.getEmbeddedLibAsPath("META-INF/" + jarName);
            pathList.add(file);
        }
        pathList.addAll(extraEntries);
        List<URL> urlList = pathList.stream().map(JkUtilsPath::toUrl).collect(Collectors.toList());
        URL[] urls = urlList.toArray(new URL[0]);
        URLClassLoader classLoader = new URLClassLoader(urls, JkClassLoader.ofCurrent().get());
        return JkInternalClassloader.of(classLoader);
    }

    public static Path getEmbeddedLibAsPath(String resourcePath) {
        URL url = JkClassLoader.ofCurrent().get().getResource(resourcePath);
        String name = resourcePath.contains("/") ? JkUtilsString.substringBeforeLast(resourcePath, "/") : resourcePath;
        Path result = URL_CACHE_DIR.resolve(name);
        if (Files.exists(result, new LinkOption[0])) {
            return result;
        }
        return JkUtilsIO.copyUrlContentToCacheFile(url, null, URL_CACHE_DIR);
    }

    public JkClassLoader get() {
        return JkClassLoader.of(this.classLoader);
    }

    public <T> T createCrossClassloaderProxy(Class<T> interfaze, String className, String staticMethodFactory, Object ... args) {
        T target = this.invokeStaticMethod(className, staticMethodFactory, args);
        ClassLoader from = Thread.currentThread().getContextClassLoader();
        return (T)Proxy.newProxyInstance(from, new Class[]{interfaze}, (InvocationHandler)new CrossClassloaderInvocationHandler(target, from));
    }

    private <T> T invokeInstanceMethod(ClassLoader from, Object object, Method method, Object ... args) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object returned;
            Object v = returned = JkUtilsReflect.invoke(object, method, args);
            return (T)v;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invokeStaticMethod(String className, String methodName, Object ... args) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Class clazz = this.get().load(className);
            Object t = JkUtilsReflect.invokeStaticMethod(clazz, methodName, args);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    static {
        JkUtilsPath.createDirectories(URL_CACHE_DIR, new FileAttribute[0]);
    }

    private class CrossClassloaderInvocationHandler
    implements InvocationHandler {
        private final Object targetObject;
        private final ClassLoader fromClassLoader;

        CrossClassloaderInvocationHandler(Object target, ClassLoader fromClassLoader) {
            this.targetObject = target;
            this.fromClassLoader = fromClassLoader;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Method targetMethod = JkUtilsReflect.methodWithSameNameAndArgType(method, this.targetObject.getClass());
            return JkInternalClassloader.this.invokeInstanceMethod(this.fromClassLoader, this.targetObject, targetMethod, args);
        }
    }
}

