/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.depmanagement.JkModuleFileProxy;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkInternalClassloader;
import dev.jeka.core.api.utils.JkUtilsReflect;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public interface JkInternalClasspathScanner {
    public static JkInternalClasspathScanner of() {
        return Cache.get();
    }

    public List<String> findClassesHavingMainMethod(ClassLoader var1);

    public List<String> findClassesMatchingAnnotations(ClassLoader var1, Predicate<List<String>> var2);

    public List<String> findClassedExtending(ClassLoader var1, Class<?> var2, Predicate<String> var3, boolean var4, boolean var5);

    public Set<Class<?>> loadClassesHavingSimpleNameMatching(Predicate<String> var1);

    public <T> Class<T> loadFirstFoundClassHavingNameOrSimpleName(String var1, Class<T> var2);

    default public Set<Class<?>> loadClassesHavingSimpleName(String simpleName) {
        return this.loadClassesHavingSimpleNameMatching(name -> name.equals(simpleName));
    }

    public JkPathSequence getClasspath(ClassLoader var1);

    public static class Cache {
        private static JkInternalClasspathScanner CACHED_INSTANCE;

        private static JkInternalClasspathScanner get() {
            if (CACHED_INSTANCE != null) {
                return CACHED_INSTANCE;
            }
            String IMPL_CLASS = "dev.jeka.core.api.java.embedded.classgraph.ClassGraphClasspathScanner";
            Class clazz = JkClassLoader.ofCurrent().loadIfExist(IMPL_CLASS);
            if (clazz != null) {
                return (JkInternalClasspathScanner)JkUtilsReflect.invokeStaticMethod(clazz, "of", new Object[0]);
            }
            JkModuleFileProxy classgraphJar = JkModuleFileProxy.ofStandardRepos("io.github.classgraph:classgraph:4.8.41");
            JkInternalClassloader internalClassloader = JkInternalClassloader.ofMainEmbeddedLibs(classgraphJar.get());
            CACHED_INSTANCE = internalClassloader.createCrossClassloaderProxy(JkInternalClasspathScanner.class, IMPL_CLASS, "of", new Object[0]);
            return CACHED_INSTANCE;
        }
    }
}

