/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkManifest;
import dev.jeka.core.api.utils.JkUtilsAssert;
import java.nio.file.Path;
import java.nio.file.PathMatcher;

public final class JkJarPacker {
    public static final JkPathMatcher EXCLUDE_SIGNATURE_MATCHER = JkPathMatcher.of(false, "meta-inf/*.rsa", "meta-inf/*.dsa", "meta-inf/*.sf");
    private final JkPathTreeSet classtrees;
    private final JkManifest manifest;
    private final JkPathTreeSet extraFiles;

    private JkJarPacker(JkPathTreeSet classTrees, JkManifest manifest, JkPathTreeSet extraFiles) {
        this.classtrees = classTrees;
        this.manifest = manifest;
        this.extraFiles = extraFiles;
    }

    public static JkJarPacker of(JkPathTreeSet classTrees) {
        JkUtilsAssert.argument(!classTrees.toList().isEmpty(), "Nothing to create jar from : " + classTrees, new Object[0]);
        return new JkJarPacker(classTrees, null, null);
    }

    public static JkJarPacker of(Path classDir) {
        return JkJarPacker.of(JkPathTreeSet.ofRoots(classDir));
    }

    public JkJarPacker withManifest(JkManifest manifest) {
        return new JkJarPacker(this.classtrees, manifest, this.extraFiles);
    }

    public JkJarPacker withExtraFiles(JkPathTreeSet extraFiles) {
        return new JkJarPacker(this.classtrees, this.manifest, extraFiles);
    }

    public void makeJar(Path resultFile) {
        if (this.manifest != null && !this.manifest.isEmpty()) {
            this.manifest.writeToStandardLocation(this.classtrees.toList().get(0).getRoot());
        }
        JkPathTreeSet treeSet = this.extraFiles == null ? JkPathTreeSet.ofEmpty() : this.extraFiles;
        this.classtrees.and(treeSet).zipTo(resultFile);
    }

    public void makeFatJar(Path resultFile, Iterable<Path> otherJars, PathMatcher filter) {
        if (this.manifest != null && !this.manifest.isEmpty()) {
            this.manifest.writeToStandardLocation(this.classtrees.toList().get(0).getRoot());
        }
        JkPathTreeSet.ofEmpty().andZips(otherJars).and(this.classtrees).andMatcher(EXCLUDE_SIGNATURE_MATCHER).andMatcher(filter).zipTo(resultFile);
    }
}

