/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class JkJavaCompileSpec<T>
implements Cloneable {
    public static final String SOURCE_OPTS = "-source";
    public static final String TARGET_OPTS = "-target";
    public static final String PROCESSOR_OPTS = "-processor";
    public static final String ENCODING_OPTS = "-encoding";
    private static final String CLASSPATH_OPTS = "-cp";
    private static final String OUTPUT_DIR_OPTS = "-d";
    private List<String> options = new LinkedList<String>();
    private JkPathTreeSet sources = JkPathTreeSet.ofEmpty();
    public final T __;

    private JkJavaCompileSpec(T __) {
        this.__ = __;
    }

    public static JkJavaCompileSpec<Void> of() {
        return JkJavaCompileSpec.ofParent(null);
    }

    public static <T> JkJavaCompileSpec<T> ofParent(T o) {
        return new JkJavaCompileSpec<T>(o);
    }

    public JkJavaCompileSpec<T> clone() {
        try {
            JkJavaCompileSpec clone = (JkJavaCompileSpec)super.clone();
            clone.options = new LinkedList<String>(this.options);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getOptions() {
        return this.options;
    }

    public Path getOutputDir() {
        String path = this.findValueAfter(OUTPUT_DIR_OPTS);
        return path == null ? null : Paths.get(path, new String[0]);
    }

    public JkJavaCompileSpec<T> setOutputDir(Path outputDir) {
        return this.addOptions(OUTPUT_DIR_OPTS, outputDir.toString());
    }

    public JkJavaVersion getSourceVersion() {
        String rawResult = this.getNextValue(SOURCE_OPTS);
        if (rawResult == null) {
            return null;
        }
        return JkJavaVersion.of(rawResult);
    }

    public JkJavaVersion getTargetVersion() {
        String rawResult = this.getNextValue(TARGET_OPTS);
        if (rawResult == null) {
            return null;
        }
        return JkJavaVersion.of(rawResult);
    }

    public JkJavaCompileSpec<T> setSourceVersion(JkJavaVersion version) {
        if (version == null) {
            return this;
        }
        return this.setOption(SOURCE_OPTS, version.get());
    }

    public JkJavaCompileSpec<T> setTargetVersion(JkJavaVersion version) {
        if (version == null) {
            return this;
        }
        return this.setOption(TARGET_OPTS, version.get());
    }

    public JkJavaCompileSpec<T> setSourceAndTargetVersion(JkJavaVersion version) {
        return this.setSourceVersion(version).setTargetVersion(version);
    }

    public String getEncoding() {
        return this.getNextValue(ENCODING_OPTS);
    }

    public JkJavaCompileSpec<T> setEncoding(String encoding) {
        if (encoding == null) {
            return this;
        }
        return this.setOption(ENCODING_OPTS, encoding);
    }

    public JkJavaCompileSpec<T> setSources(Function<JkPathTreeSet, JkPathTreeSet> modifier) {
        return this.setSources(modifier.apply(this.sources));
    }

    public JkJavaCompileSpec<T> setSources(JkPathTreeSet sources) {
        this.sources = sources.mergeDuplicateRoots();
        return this;
    }

    public JkPathTreeSet getSources() {
        return this.sources;
    }

    public List<Path> getSourceDirs() {
        return this.sources.toList().stream().map(tree -> tree.getRoot()).map(JkUtilsPath::relativizeFromWorkingDir).collect(Collectors.toList());
    }

    public JkJavaCompileSpec<T> setClasspath(Iterable<Path> files) {
        String classpath = JkPathSequence.of(files).toPath();
        return this.setOption(CLASSPATH_OPTS, classpath);
    }

    public JkPathSequence getClasspath() {
        Iterator<String> it = this.options.iterator();
        String value = null;
        while (it.hasNext() && value == null) {
            String option = it.next();
            if (!option.equals(CLASSPATH_OPTS) || !it.hasNext()) continue;
            value = it.next();
        }
        if (value == null) {
            return JkPathSequence.of();
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return JkPathSequence.of(Arrays.asList(value.split(File.pathSeparator)).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
    }

    public JkJavaCompileSpec<T> addOptions(String ... options) {
        return this.addOptions(Arrays.asList(options));
    }

    public JkJavaCompileSpec<T> addOptions(Iterable<String> options) {
        options.forEach(option -> this.options.add((String)option));
        return this;
    }

    public JkJavaCompileSpec<T> setOption(String optionName, String optionValue) {
        this.addOrReplace(optionName, optionValue);
        return this;
    }

    public JkJavaCompileSpec<T> setAnnotationProcessors(String ... annotationProcessorClassNames) {
        return this.setOption(PROCESSOR_OPTS, String.join((CharSequence)",", annotationProcessorClassNames));
    }

    public JkJavaCompileSpec<T> disableAnnotationProcessing() {
        return this.addOptions("-proc:none");
    }

    public JkJavaCompileSpec<T> setAnnotationProcessingOnly() {
        return this.addOptions("-proc:only");
    }

    public String getNextValue(String optionName) {
        return this.findValueAfter(optionName);
    }

    private String findValueAfter(String optionName) {
        Iterator<String> it = this.options.iterator();
        while (it.hasNext()) {
            String optionItem = it.next();
            if (!optionItem.equals(optionName) || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }

    private void addOrReplace(String optionName, String value) {
        int index = this.options.indexOf(optionName);
        while (index >= 0) {
            this.options.remove(index);
            if (index < this.options.size()) {
                this.options.remove(index);
            }
            index = this.options.indexOf(optionName);
        }
        this.options.add(optionName);
        this.options.add(value);
    }
}

