/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.java.JkJavaCompileSpec;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class JkJavaCompiler<T> {
    public static final PathMatcher JAVA_SOURCE_MATCHER = JkPathMatcher.of(true, "**/*.java", "*.java");
    private JkProcess compileProcess;
    private JavaCompiler compileTool;
    private SortedMap<JkJavaVersion, Path> jdkHomes = Collections.emptySortedMap();
    private String[] forkParams;
    private String[] toolParams = new String[0];
    public final T __;

    private JkJavaCompiler(T __) {
        this.__ = __;
    }

    public static JkJavaCompiler<Void> of() {
        return JkJavaCompiler.ofParent(null);
    }

    public static <T> JkJavaCompiler<T> ofParent(T parent) {
        return new JkJavaCompiler<T>(parent);
    }

    public JkJavaCompiler<T> setCompileTool(JavaCompiler compiler, String ... params) {
        this.compileTool = compiler;
        this.toolParams = params;
        this.compileProcess = null;
        return this;
    }

    public JkJavaCompiler<T> setForkedWithProcess(JkProcess compileProcess) {
        this.compileTool = null;
        this.compileProcess = compileProcess;
        return this;
    }

    public JkJavaCompiler<T> setJdkHomes(Map<JkJavaVersion, Path> jdks) {
        this.jdkHomes = new TreeMap<JkJavaVersion, Path>(jdks);
        return this;
    }

    public JkJavaCompiler<T> setForkedWithDefaultProcess(String ... processParams) {
        this.compileTool = null;
        this.forkParams = processParams;
        return this;
    }

    public JkJavaCompiler<T> setJdkHomesWithProperties(Map<String, String> jdkLocations) {
        TreeMap<JkJavaVersion, Path> jdks = new TreeMap<JkJavaVersion, Path>();
        jdkLocations.entrySet().forEach(entry -> {
            String version = JkUtilsString.substringAfterFirst((String)entry.getKey(), "jdk.");
            String path = (String)entry.getValue();
            if (version != null && path != null) {
                Path filePath = Paths.get(path, new String[0]);
                jdks.put(JkJavaVersion.of(version), filePath);
            }
        });
        this.jdkHomes = jdks;
        return this;
    }

    public boolean compile(JkJavaCompileSpec compileSpec) {
        Path outputDir = compileSpec.getOutputDir();
        List<String> options = compileSpec.getOptions();
        if (outputDir == null) {
            throw new IllegalArgumentException("Output dir option (-d) has not been specified on the compiler. Specified options : " + JkJavaCompiler.printableOptions(options));
        }
        if (!compileSpec.getSources().andMatcher(JAVA_SOURCE_MATCHER).containFiles()) {
            JkLog.info("No source files found in " + compileSpec.getSources(), new Object[0]);
            return true;
        }
        JkUtilsPath.createDirectories(outputDir, new FileAttribute[0]);
        String message = "Compile " + compileSpec.getSources() + " to " + outputDir;
        if (JkLog.isVerbose()) {
            message = message + " using options : \n" + JkJavaCompiler.printableOptions(options);
        }
        JkLog.startTask(message, new Object[0]);
        boolean result = this.runCompiler(compileSpec);
        JkLog.endTask();
        return result;
    }

    private static String printableOptions(List<String> options) {
        StringBuilder sb = new StringBuilder();
        options.stream().flatMap(item -> Stream.of(item.split(";"))).forEach(item -> sb.append(item + "\n"));
        return sb.toString();
    }

    private static List<File> toFiles(Collection<Path> paths) {
        return JkUtilsPath.toFiles(paths);
    }

    private boolean runCompiler(JkJavaCompileSpec compileSpec) {
        JkJavaVersion runningJdkVersion = JkJavaVersion.of(JkJavaCompiler.runningJdkVersion());
        if (this.compileTool != null) {
            if (compileSpec.getSourceVersion() == null || JkJavaCompiler.canCompile(this.compileTool, compileSpec.getSourceVersion())) {
                return JkJavaCompiler.runOnTool(compileSpec, this.compileTool, this.toolParams);
            }
            throw new IllegalStateException("Tool compiler does not support Java source version " + compileSpec.getSourceVersion() + ". It only supports " + this.compileTool.getSourceVersions());
        }
        if (this.compileProcess != null) {
            JkJavaCompiler.runOnProcess(compileSpec, this.compileProcess);
        }
        JavaCompiler runningJdkCompilerTool = JkJavaCompiler.getDefaultOrFail();
        if (compileSpec.getSourceVersion() == null || compileSpec.getSourceVersion().equals(runningJdkVersion)) {
            if (this.forkParams == null) {
                return JkJavaCompiler.runOnTool(compileSpec, runningJdkCompilerTool, this.toolParams);
            }
            return JkJavaCompiler.runOnProcess(compileSpec, JkProcess.ofJavaTool("javac", this.forkOptions()));
        }
        JkProcess process = this.resolveCompileProcessFromJdksForVersion(compileSpec.getSourceVersion());
        if (process != null) {
            return JkJavaCompiler.runOnProcess(compileSpec, process.addParams(this.forkOptions()));
        }
        if (JkJavaCompiler.canCompile(runningJdkCompilerTool, compileSpec.getSourceVersion())) {
            return JkJavaCompiler.runOnTool(compileSpec, runningJdkCompilerTool, this.toolParams);
        }
        throw new IllegalStateException("Cannot find suitable JDK to compile version " + compileSpec.getSourceVersion() + "\nRunning JDK is " + runningJdkVersion + " and known JDK homes are " + this.jdkHomes);
    }

    private static boolean runOnTool(JkJavaCompileSpec compileSpec, JavaCompiler compiler, String[] toolOptions) {
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        List<File> files = JkUtilsPath.toFiles(compileSpec.getSources().withMatcher(JAVA_SOURCE_MATCHER).getFiles());
        Iterable<? extends JavaFileObject> javaFileObjects = fileManager.getJavaFileObjectsFromFiles(files);
        LinkedList<String> options = new LinkedList<String>();
        options.addAll(Arrays.asList(toolOptions));
        options.addAll(compileSpec.getOptions());
        JavaCompiler.CompilationTask task = compiler.getTask(new PrintWriter(JkLog.getOutPrintStream()), null, new JkDiagnosticListener(), options, null, javaFileObjects);
        return task.call();
    }

    private static boolean runOnProcess(JkJavaCompileSpec compileSpec, JkProcess process) {
        JkLog.info("Compile using command " + process.getCommand(), new Object[0]);
        Path workingDir = Optional.ofNullable(process.getWorkingDir()).orElse(Paths.get("", new String[0]));
        LinkedList<String> sourcePaths = new LinkedList<String>();
        List<Path> sourceFiles = compileSpec.getSources().andMatcher(JAVA_SOURCE_MATCHER).getFiles();
        sourceFiles.forEach(file -> sourcePaths.add(file.toString()));
        ((JkProcess)process.addParams(compileSpec.getOptions())).addParams(sourcePaths);
        JkLog.info("" + sourcePaths.size() + " files to compile.", new Object[0]);
        int result = process.exec(new String[0]);
        return result == 0;
    }

    private static JavaCompiler getDefaultOrFail() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JkUtilsAssert.state(compiler != null, "This platform does not provide compileRunner. Try another JDK or specify option jdk.[version]=/path/to/jdk", new Object[0]);
        return compiler;
    }

    static String runningJdkVersion() {
        String fullVersion = System.getProperty("java.version");
        return JkJavaCompiler.runningJdkVersion(fullVersion);
    }

    static String runningJdkVersion(String fullVersion) {
        String[] items = fullVersion.split("\\.");
        if (items.length == 1) {
            return fullVersion;
        }
        if ("1".equals(items[0])) {
            return items[1];
        }
        return items[0];
    }

    private static boolean canCompile(JavaCompiler compilerTool, JkJavaVersion version) {
        return compilerTool.getSourceVersions().stream().map(sourceVersion -> JkUtilsString.substringAfterFirst(sourceVersion.name(), "RELEASE_")).map(JkJavaVersion::of).findAny().isPresent();
    }

    private String[] forkOptions() {
        return this.forkParams == null ? new String[]{} : this.forkParams;
    }

    private JkProcess resolveCompileProcessFromJdksForVersion(JkJavaVersion sourceVersion) {
        Path jdkPath = null;
        for (Map.Entry<JkJavaVersion, Path> entry : this.jdkHomes.entrySet()) {
            if (entry.getKey().compareTo(sourceVersion) < 0) continue;
            Path path = entry.getValue();
            if (!Files.exists(path, new LinkOption[0])) {
                JkLog.warn("JdkHome " + entry.getKey() + " " + path + " does not exist.", new Object[0]);
                continue;
            }
            JkLog.info("Found Jdk " + entry.getKey() + " " + path + " to compile for with source version=" + sourceVersion, new Object[0]);
            jdkPath = path;
            break;
        }
        if (jdkPath == null) {
            return null;
        }
        String cmd = jdkPath + "/bin/javac";
        return JkProcess.of(cmd, new String[0]);
    }

    private static class JkDiagnosticListener
    implements DiagnosticListener {
        private JkDiagnosticListener() {
        }

        public void report(Diagnostic diagnostic) {
            if (!diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) {
                JkLog.info(diagnostic.toString(), new Object[0]);
            } else {
                System.out.println(diagnostic);
            }
        }
    }
}

