/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;

public class JkJavaProcess
extends JkProcess<JkJavaProcess> {
    public static final Path CURRENT_JAVA_HOME = Paths.get(System.getProperty("java.home"), new String[0]);
    public static final Path CURRENT_JAVA_EXEC_DIR = CURRENT_JAVA_HOME.resolve("bin");

    protected JkJavaProcess() {
        super(CURRENT_JAVA_EXEC_DIR.resolve("java").toString(), new String[0]);
    }

    public static JkJavaProcess ofJava(String className) {
        JkUtilsAssert.argument(className != null, "className cannot be null", new Object[0]);
        return (JkJavaProcess)new JkJavaProcess().addParams(className);
    }

    public static JkJavaProcess ofJavaJar(Path jar, String className) {
        return (JkJavaProcess)new JkJavaProcess().addParams("-jar", jar.toString(), className);
    }

    public JkJavaProcess addAgent(Path agentLib, String agentOption) {
        JkUtilsAssert.argument(agentLib != null, "agentLib can't be null.", new Object[0]);
        JkUtilsAssert.argument(Files.exists(agentLib, new LinkOption[0]), "agentLib " + agentLib + " not found.", new Object[0]);
        JkUtilsAssert.argument(Files.isRegularFile(agentLib, new LinkOption[0]), "agentLib " + agentLib + " is a directory, should be a file.", new Object[0]);
        String arg = "-javaagent:" + agentLib;
        if (agentOption != null) {
            arg = arg + "=" + agentOption;
        }
        return (JkJavaProcess)this.addParamsFirst(arg);
    }

    public JkJavaProcess addJavaOptions(Collection<String> options) {
        return (JkJavaProcess)this.addParamsFirst(options);
    }

    public JkJavaProcess addJavaOptionsIf(boolean condition, String ... options) {
        if (condition) {
            return this.addJavaOptions(options);
        }
        return this;
    }

    public JkJavaProcess addJavaOptions(String ... options) {
        return this.addJavaOptions(Arrays.asList(options));
    }

    public JkJavaProcess setClasspath(Iterable<Path> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Classpath can't be null.");
        }
        JkPathSequence classpath = JkPathSequence.of(JkUtilsPath.disambiguate(paths));
        return this.addJavaOptions("-cp", classpath.toPath());
    }
}

