/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.utils.JkUtilsAssert;

public final class JkJavaVersion
implements Comparable<JkJavaVersion> {
    public static final JkJavaVersion V8 = JkJavaVersion.of("8");
    public static final JkJavaVersion V9 = JkJavaVersion.of("9");
    public static final JkJavaVersion V10 = JkJavaVersion.of("10");
    public static final JkJavaVersion V11 = JkJavaVersion.of("11");
    public static final JkJavaVersion V12 = JkJavaVersion.of("12");
    public static final JkJavaVersion V13 = JkJavaVersion.of("13");
    public static final JkJavaVersion V14 = JkJavaVersion.of("14");
    public static final JkJavaVersion V15 = JkJavaVersion.of("15");
    public static final JkJavaVersion V16 = JkJavaVersion.of("16");
    public static final JkJavaVersion V17 = JkJavaVersion.of("17");
    public static final JkJavaVersion V18 = JkJavaVersion.of("18");
    public static final JkJavaVersion V19 = JkJavaVersion.of("19");
    private final String value;

    public static JkJavaVersion of(String value) {
        JkUtilsAssert.argument(value != null, "version name can't be null. Use 8, 9, 10, 11...", new Object[0]);
        return new JkJavaVersion(value);
    }

    public static JkJavaVersion ofCurrent() {
        return JkJavaVersion.of(System.getProperty("java.version"));
    }

    private JkJavaVersion(String value) {
        this.value = value;
    }

    public String get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkJavaVersion that = (JkJavaVersion)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(JkJavaVersion o) {
        return JkVersion.of(this.value).compareTo(JkVersion.of(o.value));
    }
}

