/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkInternalClasspathScanner;
import dev.jeka.core.api.java.JkUrlClassLoader;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class JkManifest<T> {
    public static final String STANDARD_LOCATION = "META-INF/MANIFEST.MF";
    public static final String BUILD_JDK = "Build-Jdk";
    public static final String CREATED_BY = "Created-By";
    private static final String BUILT_BY = "Built-By";
    public static final String IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String IMPLEMENTATION_VENDOR = "Implementation-Vendor";
    private Manifest manifest;
    public final T __;

    private JkManifest(T __) {
        this.__ = __;
        this.manifest = new Manifest();
        this.manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
    }

    public static JkManifest<Void> of() {
        return JkManifest.ofParent(null);
    }

    public static <T> JkManifest<T> ofParent(T parent) {
        return new JkManifest<T>(parent);
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public JkManifest<T> set(Manifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public JkManifest<T> loadFromFile(Path file) {
        this.manifest = JkManifest.read(file);
        return this;
    }

    public JkManifest<T> loadFromJar(Path jar) {
        JkPathTree jarTree = JkPathTree.ofZip(jar);
        Path manifestFile = jarTree.get(STANDARD_LOCATION);
        if (!Files.exists(manifestFile, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + jar + " does not contains " + STANDARD_LOCATION + " entry.");
        }
        this.loadFromFile(manifestFile);
        return this;
    }

    public JkManifest<T> loadFromInputStream(InputStream inputStream) {
        return this.set(JkManifest.read(inputStream));
    }

    public JkManifest<T> loadFromClass(Class<?> clazz) {
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return this.loadFromInputStream(clazz.getClassLoader().getResourceAsStream(STANDARD_LOCATION));
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/" + STANDARD_LOCATION;
        try {
            return this.loadFromInputStream(new URL(manifestPath).openStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JkManifest<T> addMainAttribute(Attributes.Name key, String value) {
        this.manifest.getMainAttributes().putValue(key.toString(), value);
        return this;
    }

    public JkManifest<T> addAutodetectMain(Path classDir) {
        URLClassLoader classLoader = JkUrlClassLoader.of(classDir).get();
        List<String> classes = JkInternalClasspathScanner.of().findClassesHavingMainMethod(classLoader);
        if (classes.isEmpty()) {
            throw new IllegalStateException("No class with main method found.");
        }
        this.addMainClass(classes.get(0));
        return this;
    }

    public JkManifest<T> addMainAttribute(String key, String value) {
        this.manifest.getMainAttributes().putValue(key, value);
        return this;
    }

    public JkManifest<T> addMainClass(String value) {
        return this.addMainAttribute(Attributes.Name.MAIN_CLASS, value);
    }

    public JkManifest<T> addContextualInfo() {
        return this.addMainAttribute(CREATED_BY, "Jeka").addMainAttribute(BUILT_BY, System.getProperty("user.name")).addMainAttribute(BUILD_JDK, System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
    }

    public String getMainAttribute(String key) {
        return this.getManifest().getMainAttributes().getValue(key);
    }

    public String getMainAttribute(Attributes.Name name) {
        return this.getManifest().getMainAttributes().getValue(name);
    }

    public JkManifest<T> merge(Manifest other) {
        Map<String, Attributes> otherEntryAttributes = other.getEntries();
        for (String entry : otherEntryAttributes.keySet()) {
            Attributes otherAttributes = otherEntryAttributes.get(entry);
            Attributes attributes = this.manifest.getAttributes(entry);
            JkManifest.merge(attributes, otherAttributes);
        }
        JkManifest.merge(this.manifest.getMainAttributes(), other.getMainAttributes());
        return this;
    }

    public void writeToStandardLocation(Path classDir) {
        this.writeTo(classDir.resolve(STANDARD_LOCATION));
    }

    private static void merge(Attributes attributes, Attributes others) {
        for (Map.Entry<Object, Object> entry : others.entrySet()) {
            attributes.putValue(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest read(Path file) {
        JkUtilsAssert.argument(Files.exists(file, new LinkOption[0]), file.normalize() + " not found.", new Object[0]);
        JkUtilsAssert.argument(Files.isRegularFile(file, new LinkOption[0]), file.normalize() + " is directory : need file.", new Object[0]);
        Manifest manifest = new Manifest();
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            manifest.read(is);
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (IOException e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    private static Manifest read(InputStream inputStream) {
        Manifest manifest = new Manifest();
        try {
            manifest.read(inputStream);
            return manifest;
        }
        catch (IOException e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    public void writeTo(Path file) {
        JkUtilsPath.createFileSafely(file, new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            this.manifest.write(outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty() {
        Attributes mainAttributes = this.manifest.getMainAttributes();
        if (mainAttributes.size() > 1) {
            return false;
        }
        if (mainAttributes.size() == 1 && !mainAttributes.containsKey(Attributes.Name.MANIFEST_VERSION)) {
            return false;
        }
        return this.manifest.getEntries().size() == 0;
    }
}

