/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.marshalling;

import dev.jeka.core.api.marshalling.JkDomElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class JkDomDocument {
    private final Document w3cDocument;

    private JkDomDocument(Document w3cDocument) {
        this.w3cDocument = w3cDocument;
    }

    public static JkDomDocument of(Document w3cDocument) {
        return new JkDomDocument(w3cDocument);
    }

    public static JkDomDocument of(String rootName) {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element element = doc.createElement(rootName);
        doc.appendChild(element);
        return new JkDomDocument(doc);
    }

    public static JkDomDocument parse(InputStream inputStream, DocumentBuilder documentBuilder) {
        Document doc;
        try {
            doc = documentBuilder.parse(inputStream);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new JkDomDocument(doc);
    }

    public static JkDomDocument parse(InputStream inputStream) {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return JkDomDocument.parse(inputStream, builder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JkDomDocument parse(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            JkDomDocument jkDomDocument = JkDomDocument.parse(is);
            return jkDomDocument;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Document getW3cDocument() {
        return this.w3cDocument;
    }

    public JkDomElement root() {
        Element root = this.w3cDocument.getDocumentElement();
        return JkDomElement.of(null, root);
    }

    public void print(OutputStream out) {
        this.print(out, configurer -> {});
    }

    public void save(Path file) {
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            this.print(os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void print(OutputStream out, Consumer<Transformer> transformerConfigurer) {
        Transformer transformer;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformerConfigurer.accept(transformer);
        try {
            transformer.transform(new DOMSource(this.w3cDocument), new StreamResult(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.print(outputStream);
        return new String(outputStream.toByteArray(), Charset.forName("utf-8"));
    }
}

