/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkResourceProcessor;
import dev.jeka.core.api.function.JkRunnables;
import dev.jeka.core.api.java.JkJavaCompileSpec;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkProjectConstruction;
import dev.jeka.core.api.project.JkProjectTesting;
import dev.jeka.core.api.system.JkLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class JkProjectCompilation<T> {
    public static final String RESOURCES_PROCESS_ACTION = "resources-process";
    public static final String JAVA_SOURCES_COMPILE_ACTION = "java-sources-compile";
    private static final String PRODUCTION_PURPOSE = "production";
    private static final String TEST_PURPOSE = "test";
    public final T __;
    private final JkProjectConstruction construction;
    private final JkRunnables<JkProjectCompilation<T>> preCompileActions;
    private final JkRunnables<JkProjectCompilation<T>> compileActions;
    private final JkRunnables<JkProjectCompilation<T>> postCompileActions;
    private final JkResourceProcessor<JkProjectCompilation<T>> resourceProcessor;
    private final JkCompileLayout<JkProjectCompilation<T>> layout;
    private Function<JkDependencySet, JkDependencySet> dependenciesModifier = deps -> deps;
    private Supplier<JkDependencySet> dependencyBootSupplier = () -> JkDependencySet.of();
    private final LinkedList<String> extraJavaCompilerOptions = new LinkedList();
    private boolean done;
    private String purpose;
    private Supplier<JkJavaCompileSpec> compileSpecSupplier;

    private JkProjectCompilation(JkProjectConstruction construction, String purpose, T parent) {
        this.__ = parent;
        this.purpose = purpose;
        this.construction = construction;
        this.resourceProcessor = JkResourceProcessor.ofParent(this);
        this.preCompileActions = JkRunnables.ofParent(this).setLogRunnableName(true).append(RESOURCES_PROCESS_ACTION, this::processResources);
        this.compileActions = JkRunnables.ofParent(this).setLogRunnableName(true).append(JAVA_SOURCES_COMPILE_ACTION, this::compileJava);
        this.postCompileActions = JkRunnables.ofParent(this).setLogRunnableName(true);
        this.layout = JkCompileLayout.ofParent(this).setBaseDirSupplier(construction.getProject()::getBaseDir).setOutputDirSupplier(construction.getProject()::getOutputDir);
    }

    static JkProjectCompilation<JkProjectConstruction> ofProd(JkProjectConstruction projectProduction) {
        JkProjectCompilation<JkProjectConstruction> result = new JkProjectCompilation<JkProjectConstruction>(projectProduction, PRODUCTION_PURPOSE, projectProduction);
        result.compileSpecSupplier = () -> result.computeProdCompileSpec();
        return result;
    }

    static JkProjectCompilation<JkProjectTesting> ofTest(JkProjectConstruction construction, JkProjectTesting parent) {
        JkProjectCompilation<JkProjectTesting> result = new JkProjectCompilation<JkProjectTesting>(construction, TEST_PURPOSE, parent);
        result.dependencyBootSupplier = () -> construction.getRuntimeDependencies().merge(construction.getCompilation().getDependencies()).getResult();
        result.compileSpecSupplier = () -> result.computeTestCompileSpec(construction.getCompilation());
        result.layout.setSourceMavenStyle(JkCompileLayout.Concern.TEST).setStandardOuputDirs(JkCompileLayout.Concern.TEST);
        return result;
    }

    public JkProjectCompilation apply(Consumer<JkProjectCompilation> consumer) {
        consumer.accept(this);
        return this;
    }

    public JkCompileLayout<JkProjectCompilation<T>> getLayout() {
        return this.layout;
    }

    public void run() {
        JkLog.startTask("Run whole compilation process for " + this.purpose, new Object[0]);
        this.preCompileActions.run();
        this.compileActions.run();
        this.postCompileActions.run();
        JkLog.endTask();
    }

    public void runIfNeeded() {
        if (this.done) {
            JkLog.trace("java-sources-compile already done. Won't perform again.", new Object[0]);
        } else {
            this.run();
            this.done = true;
        }
    }

    public JkRunnables<JkProjectCompilation<T>> getPreCompileActions() {
        return this.preCompileActions;
    }

    public JkRunnables<JkProjectCompilation<T>> getCompileActions() {
        return this.postCompileActions;
    }

    public JkRunnables<JkProjectCompilation<T>> getPostCompileActions() {
        return this.postCompileActions;
    }

    public List<String> getExtraJavaCompilerOptions() {
        return Collections.unmodifiableList(this.extraJavaCompilerOptions);
    }

    public JkProjectCompilation<T> addJavaCompilerOptions(String ... options) {
        this.extraJavaCompilerOptions.addAll(Arrays.asList(options));
        return this;
    }

    public JkResourceProcessor<JkProjectCompilation<T>> getResourceProcessor() {
        return this.resourceProcessor;
    }

    public JkProjectCompilation<T> configureDependencies(Function<JkDependencySet, JkDependencySet> modifier) {
        this.dependenciesModifier = this.dependenciesModifier.andThen(modifier);
        return this;
    }

    public JkResolveResult resolveDependencies() {
        return this.construction.getDependencyResolver().resolve(this.getDependencies());
    }

    public JkDependencySet getDependencies() {
        return this.dependenciesModifier.apply(this.dependencyBootSupplier.get());
    }

    private void processResources() {
        this.getResourceProcessor().generate(this.layout.resolveResources(), this.layout.resolveClassDir());
    }

    private void compileJava() {
        boolean success = this.construction.getCompiler().compile(this.compileSpecSupplier.get());
        if (!success) {
            throw new IllegalStateException("Compilation of Java sources failed.");
        }
    }

    private JkJavaCompileSpec computeProdCompileSpec() {
        return JkJavaCompileSpec.of().setSourceAndTargetVersion(this.construction.getJvmTargetVersion()).setEncoding(this.construction.getSourceEncoding()).setClasspath(this.resolveDependencies().getFiles()).setSources(this.layout.resolveSources().and(JkPathTree.of(this.layout.resolveGeneratedSourceDir()))).addOptions(this.extraJavaCompilerOptions).setOutputDir(this.layout.resolveClassDir());
    }

    private JkJavaCompileSpec computeTestCompileSpec(JkProjectCompilation prodStep) {
        JkDependencySet dependencies = this.getDependencies();
        return JkJavaCompileSpec.of().setSourceAndTargetVersion(this.construction.getJvmTargetVersion()).setEncoding(this.construction.getSourceEncoding()).setClasspath(this.construction.getDependencyResolver().resolve(dependencies).getFiles().andPrepend(prodStep.layout.resolveClassDir())).setSources(this.layout.resolveSources().and(this.layout.resolveGeneratedSourceDir())).addOptions(this.extraJavaCompilerOptions).setOutputDir(this.layout.resolveClassDir());
    }
}

