/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkProjectDependencies;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.depmanagement.resolution.JkResolvedDependencyNode;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJarPacker;
import dev.jeka.core.api.java.JkJavaCompiler;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.java.JkManifest;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.project.JkProjectTesting;
import dev.jeka.core.api.system.JkLog;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JkProjectConstruction {
    private static final JkJavaVersion DEFAULT_JAVA_VERSION = JkJavaVersion.V8;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final JkProject project;
    private final JkJavaCompiler<JkProjectConstruction> compiler;
    private JkJavaVersion jvmTargetVersion = DEFAULT_JAVA_VERSION;
    private String sourceEncoding = "UTF-8";
    private final JkDependencyResolver<JkProjectConstruction> dependencyResolver;
    private final JkProjectCompilation<JkProjectConstruction> compilation;
    private final JkProjectTesting testing;
    private PathMatcher fatJarFilter = JkPathMatcher.of();
    private final JkManifest manifest;
    private JkPathTreeSet fatJarContentCustomizer = JkPathTreeSet.ofEmpty();
    private UnaryOperator<JkDependencySet> dependencySetModifier = x -> x;
    private boolean textAndLocalDependenciesAdded;
    public JkProject __;

    JkProjectConstruction(JkProject project) {
        this.project = project;
        this.__ = project;
        this.dependencyResolver = JkDependencyResolver.ofParent(this).addRepos(JkRepo.ofLocal(), JkRepo.ofMavenCentral()).setUseCache(true);
        this.compiler = JkJavaCompiler.ofParent(this);
        this.compilation = JkProjectCompilation.ofProd(this);
        this.testing = new JkProjectTesting(this);
        this.manifest = JkManifest.ofParent(this);
    }

    public JkProjectConstruction apply(Consumer<JkProjectConstruction> consumer) {
        consumer.accept(this);
        return this;
    }

    public JkDependencyResolver<JkProjectConstruction> getDependencyResolver() {
        return this.dependencyResolver;
    }

    public JkJavaCompiler<JkProjectConstruction> getCompiler() {
        return this.compiler;
    }

    public JkProjectConstruction setJvmTargetVersion(JkJavaVersion jvmTargetVersion) {
        this.jvmTargetVersion = jvmTargetVersion;
        return this;
    }

    public JkJavaVersion getJvmTargetVersion() {
        return this.jvmTargetVersion != null ? this.jvmTargetVersion : DEFAULT_JAVA_VERSION;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public JkProjectConstruction setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
        return this;
    }

    public JkProjectCompilation<JkProjectConstruction> getCompilation() {
        return this.compilation;
    }

    public JkProjectDependencies getProjectDependencies() {
        return JkProjectDependencies.of(this.compilation.getDependencies(), this.getRuntimeDependencies(), this.testing.getCompilation().getDependencies());
    }

    public JkProjectTesting getTesting() {
        return this.testing;
    }

    public JkManifest<JkProjectConstruction> getManifest() {
        return this.manifest;
    }

    JkProject getProject() {
        return this.project;
    }

    private void addManifestDefaults() {
        JkModuleId moduleId = this.project.getPublication().getModuleId();
        String version = this.project.getPublication().getVersion().getValue();
        if (this.manifest.getMainAttribute("Implementation-Title") == null && moduleId != null) {
            this.manifest.addMainAttribute("Implementation-Title", moduleId.getName());
        }
        if (this.manifest.getMainAttribute("Implementation-Vendor") == null && moduleId != null) {
            this.manifest.addMainAttribute("Implementation-Vendor", moduleId.getGroup());
        }
        if (this.manifest.getMainAttribute("Implementation-Version") == null && version != null) {
            this.manifest.addMainAttribute("Implementation-Version", version);
        }
    }

    public void createBinJar(Path target) {
        this.compilation.runIfNeeded();
        this.testing.runIfNeeded();
        this.addManifestDefaults();
        JkJarPacker.of(this.compilation.getLayout().resolveClassDir()).withManifest(this.manifest).withExtraFiles(this.getExtraFilesToIncludeInJar()).makeJar(target);
    }

    public void createBinJar() {
        this.createBinJar(this.project.getArtifactProducer().getArtifactPath(JkArtifactId.ofMainArtifact("jar")));
    }

    public void createFatJar(Path target) {
        this.compilation.runIfNeeded();
        this.testing.runIfNeeded();
        JkLog.startTask("Packing fat jar...", new Object[0]);
        JkPathSequence classpath = this.resolveRuntimeDependencies().getFiles();
        this.addManifestDefaults();
        JkJarPacker.of(this.compilation.getLayout().resolveClassDir()).withManifest(this.manifest).withExtraFiles(this.getExtraFilesToIncludeInJar()).makeFatJar(target, classpath, this.fatJarFilter);
        JkLog.endTask();
    }

    public void createFatJar() {
        this.createFatJar(this.project.getArtifactProducer().getArtifactPath(JkArtifactId.of("fat", "jar")));
    }

    public JkPathTreeSet getExtraFilesToIncludeInJar() {
        return this.fatJarContentCustomizer;
    }

    public JkProjectConstruction customizeFatJarContent(Function<JkPathTreeSet, JkPathTreeSet> customizer) {
        this.fatJarContentCustomizer = customizer.apply(this.fatJarContentCustomizer);
        return this;
    }

    public JkProjectConstruction configureRuntimeDependencies(UnaryOperator<JkDependencySet> modifier) {
        this.dependencySetModifier = modifier;
        return this;
    }

    public JkDependencySet getRuntimeDependencies() {
        return (JkDependencySet)this.dependencySetModifier.apply(this.compilation.getDependencies());
    }

    public JkResolveResult resolveRuntimeDependencies() {
        return this.dependencyResolver.resolve(this.getRuntimeDependencies().normalised(this.project.getDuplicateConflictStrategy()));
    }

    public void addTextAndLocalDependencies() {
        if (this.textAndLocalDependenciesAdded) {
            return;
        }
        Path baseDir = this.project.getBaseDir();
        JkProjectDependencies localDeps = JkProjectDependencies.ofLocal(baseDir.resolve("jeka/libs"));
        JkProjectDependencies textDeps = JkProjectDependencies.ofTextDescriptionIfExist(baseDir.resolve("jeka/libs/dependencies.txt"));
        JkProjectDependencies extraDeps = localDeps.and(textDeps);
        this.getCompilation().configureDependencies(deps -> deps.and(extraDeps.getCompile()));
        this.configureRuntimeDependencies(deps -> deps.and(extraDeps.getRuntime()));
        this.getTesting().getCompilation().configureDependencies(deps -> extraDeps.getTest().and((JkDependencySet)deps));
        this.textAndLocalDependenciesAdded = true;
    }

    public Document getDependenciesAsXml() {
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element root = document.createElement("dependencies");
        document.appendChild(root);
        root.appendChild(this.xmlDeps(document, "compile", this.getCompilation().getDependencies()));
        root.appendChild(this.xmlDeps(document, "runtime", this.getRuntimeDependencies()));
        root.appendChild(this.xmlDeps(document, "test", this.getTesting().getCompilation().getDependencies()));
        return document;
    }

    private Element xmlDeps(Document document, String purpose, JkDependencySet deps) {
        JkResolveResult resolveResult = this.getProject().getConstruction().getDependencyResolver().resolve(deps);
        JkResolvedDependencyNode tree = resolveResult.getDependencyTree();
        Element element = tree.toDomElement(document, true);
        element.setAttribute("purpose", purpose);
        return element;
    }
}

