/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavadocProcessor;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.project.JkProjectConstruction;
import dev.jeka.core.api.system.JkLog;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;

public class JkProjectDocumentation {
    private final JkProject project;
    private final JkJavadocProcessor<JkProjectDocumentation> javadocProcessor;
    private boolean done;
    private String javadocDir = "javadoc";
    public final JkProject __;

    JkProjectDocumentation(JkProject project) {
        this.project = project;
        this.__ = project;
        this.javadocProcessor = JkJavadocProcessor.ofParent(this);
    }

    public JkProjectDocumentation apply(Consumer<JkProjectDocumentation> consumer) {
        consumer.accept(this);
        return this;
    }

    public JkJavadocProcessor<JkProjectDocumentation> getJavadocProcessor() {
        return this.javadocProcessor;
    }

    public void run() {
        JkProjectConstruction construction = this.project.getConstruction();
        JkProjectCompilation<JkProjectConstruction> compilation = construction.getCompilation();
        JkPathSequence classpath = construction.getDependencyResolver().resolve(compilation.getDependencies().normalised(this.project.getDuplicateConflictStrategy())).getFiles();
        Path dir = this.project.getOutputDir().resolve(this.javadocDir);
        JkPathTreeSet sources = compilation.getLayout().resolveSources();
        this.javadocProcessor.make(classpath, sources, dir);
    }

    public void runIfNecessary() {
        if (this.done && !Files.exists(this.project.getOutputDir().resolve(this.javadocDir), new LinkOption[0])) {
            JkLog.info("Javadoc already generated. Won't perfom again", new Object[0]);
        } else {
            this.run();
            this.done = true;
        }
    }

    public Path getJavadocDir() {
        return this.project.getOutputDir().resolve(this.javadocDir);
    }

    public JkProjectDocumentation setJavadocDir(String javadocDir) {
        this.javadocDir = javadocDir;
        return this;
    }

    public void createJavadocJar(Path target) {
        this.runIfNecessary();
        Path javadocDir = this.getJavadocDir();
        JkPathTree.of(javadocDir).zipTo(target);
    }

    public void createJavadocJar() {
        this.createJavadocJar(this.project.getArtifactProducer().getArtifactPath(JkProject.JAVADOC_ARTIFACT_ID));
    }

    public void createSourceJar(Path target) {
        JkProjectCompilation<JkProjectConstruction> compilation = this.project.getConstruction().getCompilation();
        compilation.getLayout().resolveSources().and(compilation.getLayout().resolveGeneratedSourceDir()).zipTo(target);
    }

    public void createSourceJar() {
        this.createSourceJar(this.project.getArtifactProducer().getArtifactPath(JkProject.SOURCES_ARTIFACT_ID));
    }

    void reset() {
        this.done = false;
    }
}

