/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.artifact.JkStandardFileArtifactProducer;
import dev.jeka.core.api.depmanagement.publication.JkIvyPublication;
import dev.jeka.core.api.depmanagement.publication.JkMavenPublication;
import dev.jeka.core.api.function.JkRunnables;
import dev.jeka.core.api.project.JkProject;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class JkProjectPublication {
    private final JkProject project;
    private final JkMavenPublication<JkProjectPublication> maven;
    private final JkIvyPublication<JkProjectPublication> ivy;
    private final JkRunnables<JkProjectPublication> preActions;
    private final JkRunnables<JkProjectPublication> postActions;
    private boolean publishMaven = true;
    private boolean publishIvy = false;
    public final JkProject __;

    JkProjectPublication(JkProject project) {
        this.project = project;
        this.__ = project;
        JkVersionedModule.ConflictStrategy conflictStrategy = project.getDuplicateConflictStrategy();
        JkStandardFileArtifactProducer<JkProject> artifactLocator = project.getArtifactProducer();
        this.maven = JkMavenPublication.of(this).setArtifactLocatorSupplier(() -> project.getArtifactProducer()).configureDependencies(deps -> JkMavenPublication.computeMavenPublishDependencies(project.getConstruction().getCompilation().getDependencies(), project.getConstruction().getRuntimeDependencies(), project.getDuplicateConflictStrategy()));
        this.ivy = JkIvyPublication.of(this).addArtifacts(() -> project.getArtifactProducer()).configureDependencies(deps -> JkIvyPublication.getPublishDependencies(project.getConstruction().getCompilation().getDependencies(), project.getConstruction().getRuntimeDependencies(), project.getDuplicateConflictStrategy()));
        this.preActions = JkRunnables.ofParent(this);
        this.postActions = JkRunnables.ofParent(this);
    }

    public JkProjectPublication apply(Consumer<JkProjectPublication> consumer) {
        consumer.accept(this);
        return this;
    }

    public JkRunnables<JkProjectPublication> getPreActions() {
        return this.preActions;
    }

    public JkRunnables<JkProjectPublication> getPostActions() {
        return this.postActions;
    }

    public JkMavenPublication<JkProjectPublication> getMaven() {
        return this.maven;
    }

    public JkIvyPublication<JkProjectPublication> getIvy() {
        return this.ivy;
    }

    public void publish() {
        this.preActions.run();
        if (this.publishMaven) {
            this.maven.publish();
        }
        if (this.publishIvy) {
            this.ivy.publish();
        }
        this.postActions.run();
    }

    public void publishLocal() {
        this.preActions.run();
        if (this.publishMaven) {
            this.maven.publishLocal();
        }
        if (this.publishIvy) {
            this.ivy.publishLocal();
        }
        this.postActions.run();
    }

    public boolean isPublishMaven() {
        return this.publishMaven;
    }

    public JkProjectPublication setPublishMaven(boolean publishMaven) {
        this.publishMaven = publishMaven;
        return this;
    }

    public boolean isPublishIvy() {
        return this.publishIvy;
    }

    public JkProjectPublication setPublishIvy(boolean publishIvy) {
        this.publishIvy = publishIvy;
        return this;
    }

    public JkModuleId getModuleId() {
        return Optional.ofNullable(this.maven.getModuleId()).orElseGet(this.ivy::getModuleId);
    }

    public JkVersion getVersion() {
        return Optional.ofNullable(this.maven.getVersion()).orElseGet(this.ivy::getVersion);
    }

    public JkProjectPublication setModuleId(String moduleId) {
        this.maven.setModuleId(moduleId);
        this.ivy.setModuleId(moduleId);
        return this;
    }

    public JkProjectPublication setVersion(String version) {
        return this.setVersion(() -> version);
    }

    public JkProjectPublication setVersion(Supplier<String> versionSupplier) {
        this.maven.setVersion(versionSupplier);
        this.ivy.setVersion(versionSupplier);
        return this;
    }

    public JkProjectPublication setRepos(JkRepoSet repos) {
        this.maven.setRepos(repos);
        this.ivy.setRepos(repos);
        return this;
    }

    public JkProjectPublication setDefaultSigner(UnaryOperator<Path> signer) {
        this.maven.setDefaultSigner(signer);
        this.ivy.setDefaultSigner(signer);
        return this;
    }

    public JkRepo findFirstNonLocalRepo() {
        return this.getMaven().getRepos().getRepos().stream().filter(repo1 -> !repo1.isLocal()).findFirst().orElse(this.getIvy().getRepos().getRepos().stream().filter(repo1 -> !repo1.isLocal()).findFirst().orElse(null));
    }
}

