/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.project.JkProjectCompilation;
import dev.jeka.core.api.project.JkProjectConstruction;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.testing.JkTestProcessor;
import dev.jeka.core.api.testing.JkTestResult;
import dev.jeka.core.api.testing.JkTestSelection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class JkProjectTesting {
    private final JkProjectConstruction construction;
    private final JkProjectCompilation<JkProjectTesting> compilation;
    private JkTestProcessor testProcessor;
    private JkTestSelection testSelection;
    private String reportDir = "test-report";
    private boolean done;
    private boolean skipped;
    private boolean breakOnFailures = true;
    public final JkProjectConstruction __;

    JkProjectTesting(JkProjectConstruction construction) {
        this.construction = construction;
        this.__ = construction;
        this.compilation = JkProjectCompilation.ofTest(construction, this);
        this.testProcessor = this.defaultTestProcessor();
        this.testSelection = this.defaultTestSelection();
    }

    public JkProjectTesting apply(Consumer<JkProjectTesting> consumer) {
        consumer.accept(this);
        return this;
    }

    public JkTestSelection<JkProjectTesting> getTestSelection() {
        return this.testSelection;
    }

    public JkTestProcessor<JkProjectTesting> getTestProcessor() {
        return this.testProcessor;
    }

    public JkProjectCompilation<JkProjectTesting> getCompilation() {
        return this.compilation;
    }

    public JkPathSequence getTestClasspath() {
        JkDependencyResolver<JkProjectConstruction> resolver = this.construction.getDependencyResolver();
        JkProjectCompilation<JkProjectConstruction> prodCompilation = this.construction.getCompilation();
        return JkPathSequence.of().and(this.compilation.getLayout().resolveClassDir()).and(this.compilation.resolveDependencies().getFiles()).and(prodCompilation.getLayout().resolveClassDir()).and(this.construction.resolveRuntimeDependencies().getFiles()).withoutDuplicates();
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public JkProjectTesting setSkipped(boolean skipped) {
        this.skipped = skipped;
        return this;
    }

    public boolean isBreakOnFailures() {
        return this.breakOnFailures;
    }

    public JkProjectTesting setBreakOnFailures(boolean breakOnFailures) {
        this.breakOnFailures = breakOnFailures;
        return this;
    }

    public Path getReportDir() {
        return this.construction.getProject().getOutputDir().resolve(this.reportDir);
    }

    public JkProjectTesting setReportDir(String reportDir) {
        this.reportDir = reportDir;
        return this;
    }

    public void run() {
        JkLog.startTask("Process tests", new Object[0]);
        this.construction.getCompilation().runIfNeeded();
        this.compilation.run();
        this.executeWithTestProcessor();
        JkLog.endTask();
    }

    public void runIfNeeded() {
        if (this.done) {
            JkLog.trace("Tests has already been performed. Won't do it again.", new Object[0]);
        } else if (this.skipped) {
            JkLog.info("Tests are skipped. Won't perform.", new Object[0]);
        } else {
            this.run();
            this.done = true;
        }
    }

    void reset() {
        this.done = false;
    }

    private void executeWithTestProcessor() {
        UnaryOperator op = paths -> paths.resolvedTo(this.construction.getProject().getOutputDir());
        this.testSelection.setTestClassRoots(op);
        JkTestResult result = this.testProcessor.launch(this.getTestClasspath(), this.testSelection);
        if (this.breakOnFailures) {
            result.assertNoFailure();
        }
    }

    private JkTestProcessor<JkProjectTesting> defaultTestProcessor() {
        JkTestProcessor<JkProjectTesting> result = JkTestProcessor.ofParent(this);
        Path reportDir = this.compilation.getLayout().getOutputDir().resolve(this.reportDir);
        result.setRepoSetSupplier(() -> this.construction.getDependencyResolver().getRepos()).getEngineBehavior().setLegacyReportDir(reportDir).setProgressDisplayer(JkTestProcessor.JkProgressOutputStyle.ONE_LINE);
        return result;
    }

    private JkTestSelection<JkProjectTesting> defaultTestSelection() {
        return JkTestSelection.ofParent(this).addTestClassRoots(Paths.get(this.compilation.getLayout().getClassDir(), new String[0]));
    }
}

