/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.io.PrintStream;

public class JkBusyIndicator {
    private static final long WAIT_TIME = 40L;
    private static JkBusyIndicator instance;
    private final String text;
    private boolean stopped;
    private Thread thread;
    private final PrintStream printStream;

    private JkBusyIndicator(String text, PrintStream printStream) {
        this.text = text;
        this.printStream = printStream;
    }

    public static void start(String message) {
        if (!JkLog.isAcceptAnimation()) {
            return;
        }
        if (instance != null) {
            throw new IllegalStateException("A running instance of Busy Indicator is already running. Stop it prior starting a new one.");
        }
        instance = new JkBusyIndicator(message, JkLog.getOutPrintStream());
        JkBusyIndicator.instance.printStream.print(JkBusyIndicator.instance.text + " ");
        JkBusyIndicator.instance.printStream.flush();
        JkBusyIndicator.instance.thread = new Thread(instance::round);
        JkBusyIndicator.instance.thread.setName("Jeka-busyIndicator");
        JkBusyIndicator.instance.thread.start();
    }

    public static synchronized void stop() {
        if (instance == null) {
            return;
        }
        JkBusyIndicator.instance.stopped = true;
        JkUtilsSystem.join(JkBusyIndicator.instance.thread);
        instance = null;
    }

    private void round() {
        while (!this.stopped) {
            this.printStream.print('/');
            this.printStream.flush();
            JkUtilsSystem.sleep(40L);
            this.printStream.print('\b');
            this.printStream.print('-');
            this.printStream.flush();
            JkUtilsSystem.sleep(40L);
            this.printStream.print('\b');
            this.printStream.print('\\');
            this.printStream.flush();
            JkUtilsSystem.sleep(40L);
            this.printStream.print('\b');
            this.printStream.print('|');
            this.printStream.flush();
            JkUtilsSystem.sleep(40L);
            this.printStream.print('\b');
            this.printStream.flush();
        }
        this.printStream.print(' ');
        this.printStream.print('\b');
        for (int i = 0; i <= JkBusyIndicator.instance.text.length(); ++i) {
            this.printStream.print('\b');
            this.printStream.print(' ');
            this.printStream.print('\b');
        }
        this.printStream.flush();
    }
}

