/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkIndentLogDecorator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;

public final class JkDebugLogDecorator
extends JkLog.JkLogDecorator {
    private transient MarginStream marginOut;
    private transient MarginStream marginErr;
    private transient PrintStream out;
    private transient PrintStream err;

    @Override
    protected void init(PrintStream targetOut, PrintStream targetErr) {
        this.marginErr = this.marginOut = new MarginStream(targetOut);
        this.err = this.out = new PrintStream(this.marginOut);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.marginOut = new MarginStream(System.out);
        this.marginErr = new MarginStream(System.err);
    }

    @Override
    public void handle(JkLog.JkLogEvent event) {
        JkLog.Type logType = event.getType();
        PrintStream stream = this.out;
        if (logType == JkLog.Type.ERROR || logType == JkLog.Type.WARN) {
            stream.flush();
            stream = this.err;
        }
        String message = event.getMessage();
        if (event.getType().isTraceWarnOrError()) {
            message = "[" + (Object)((Object)event.getType()) + "] " + message;
        }
        if (logType != JkLog.Type.END_TASK) {
            if (logType == JkLog.Type.START_TASK) {
                stream.print(message);
                this.marginOut.notifyStart();
                this.marginErr.notifyStart();
            } else {
                stream.println(message);
            }
        }
    }

    @Override
    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public PrintStream getErr() {
        return this.err;
    }

    static class MarginStream
    extends OutputStream {
        private static final int STACKTRACE_PREFIX_SIZE = 70;
        private final PrintStream delegate;
        private int lastByte = 10;
        private boolean pendingStart;
        private boolean endTask;

        void notifyStart() {
            this.flush();
            this.pendingStart = true;
        }

        public MarginStream(PrintStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int aByte) throws IOException {
            if (this.pendingStart & !this.endTask) {
                this.delegate.write(10);
                this.lastByte = 10;
                this.pendingStart = false;
            }
            if (this.lastByte == 10) {
                Integer level = JkLog.getCurrentNestedLevel();
                if (this.endTask) {
                    Integer n = level;
                    Integer n2 = level = Integer.valueOf(level + 1);
                }
                this.delegate.write(MarginStream.stackTraceSuffix().getBytes(StandardCharsets.UTF_8));
                for (int j = 0; j < level; ++j) {
                    this.delegate.write(JkIndentLogDecorator.MARGIN_UNIT);
                }
            }
            this.delegate.write(aByte);
            this.lastByte = aByte;
        }

        private static String stackTraceSuffix() {
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            StackTraceElement element = MarginStream.findStackElementNext(elements, JkLog.class, null);
            if (element == null) {
                element = MarginStream.findStackElementNext(elements, PrintStream.class, "print");
            }
            if (element != null) {
                return JkUtilsString.padEnd(MarginStream.format(element), 70, ' ') + ":";
            }
            return JkUtilsString.padEnd("", 70, ' ') + ":";
        }

        private static StackTraceElement findStackElementNext(StackTraceElement[] elements, Class clazz, String method) {
            boolean found = false;
            for (int i = 0; i < elements.length; ++i) {
                boolean matchMethod;
                StackTraceElement stackTraceElement = elements[i];
                String className = stackTraceElement.getClassName();
                boolean matchClass = className.equals(clazz.getName());
                boolean bl = matchMethod = method == null ? true : method.equals(stackTraceElement.getMethodName());
                if (matchClass && matchMethod) {
                    found = true;
                    continue;
                }
                if (!found || matchClass) continue;
                return stackTraceElement;
            }
            return null;
        }

        private static String format(StackTraceElement stackTraceElement) {
            String line = String.format("%s.%s(line:%s)", MarginStream.extractClassName(stackTraceElement.getClassName()), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
            if (line.length() > 70) {
                line = line.substring(0, 70);
            }
            return JkUtilsString.padEnd(line, 70, ' ');
        }

        private static String extractClassName(String fullClassName) {
            LinkedList<String> resultItems = new LinkedList<String>();
            String[] items = fullClassName.split("\\.");
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                String firstLetter = item.substring(0, 1);
                if (firstLetter.equals(firstLetter.toUpperCase())) {
                    resultItems.add(item);
                    continue;
                }
                resultItems.add(firstLetter);
            }
            return String.join((CharSequence)".", resultItems);
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }
}

