/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.utils.JkUtilsString;
import java.io.File;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class JkInfo {
    private static String version;
    public static final String JEKA_MODULE_ID = "dev.jeka:jeka-core";

    public static String getJekaVersion() {
        if (JkUtilsString.isBlank(version)) {
            Class<JkInfo> clazz = JkInfo.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                String relativePath = clazz.getName().replace('.', File.separatorChar) + ".class";
                String classFolder = classPath.substring(0, classPath.length() - relativePath.length() - 1);
                String manifestPath = classFolder + "/META-INF/MANIFEST.MF";
                version = JkInfo.readVersionFrom(manifestPath);
            } else {
                String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
                version = JkInfo.readVersionFrom(manifestPath);
            }
        }
        return version;
    }

    private static String readVersionFrom(String manifestPath) {
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attrs = manifest.getMainAttributes();
            return attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

