/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class JkMemoryBufferLogDecorator
extends JkLog.JkLogDecorator {
    private static JkMemoryBufferLogDecorator jkLogInstance;
    private final JkLog.JkLogDecorator delegate;
    private final ByteArrayOutputStream byteArrayBufferStream = JkMemoryBufferLogDecorator.byteArrayBufferStream();
    private final PrintStream bufferStream = new PrintStream(this.byteArrayBufferStream);
    private final PrintStream originalTargetOut;
    private final PrintStream originalTargetErr;

    private JkMemoryBufferLogDecorator(JkLog.JkLogDecorator delegate) {
        this.delegate = delegate;
        this.originalTargetOut = delegate.getTargetOut();
        this.originalTargetErr = delegate.getTargetErr();
    }

    @Override
    public void init(PrintStream out, PrintStream err) {
        this.delegate.init(this.bufferStream, this.bufferStream);
    }

    @Override
    public PrintStream getOut() {
        return this.delegate.getErr();
    }

    @Override
    public PrintStream getErr() {
        return this.delegate.getErr();
    }

    @Override
    public void handle(JkLog.JkLogEvent event) {
        this.delegate.handle(event);
    }

    public static void activateOnJkLog() {
        JkLog.JkLogDecorator delegate = JkLog.getDecorator();
        JkUtilsAssert.state(delegate != jkLogInstance, "This decorator is currently used by JkLog. Inactivate it prior rebind again.", new Object[0]);
        jkLogInstance = new JkMemoryBufferLogDecorator(delegate);
        JkLog.setDecorator(jkLogInstance);
    }

    public static void inactivateOnJkLog() {
        JkUtilsAssert.state(jkLogInstance != null, "This decorator is not currently activated.", new Object[0]);
        JkLog.JkLogDecorator delegate = JkMemoryBufferLogDecorator.jkLogInstance.delegate;
        delegate.init(JkMemoryBufferLogDecorator.jkLogInstance.originalTargetOut, JkMemoryBufferLogDecorator.jkLogInstance.originalTargetErr);
        jkLogInstance = null;
        JkLog.setDecorator(delegate);
    }

    public static boolean isActive() {
        return jkLogInstance != null;
    }

    public static void flush() {
        JkUtilsAssert.state(JkMemoryBufferLogDecorator.isActive(), "This decorator must be activated in order to flush", new Object[0]);
        byte[] bytes = JkMemoryBufferLogDecorator.jkLogInstance.byteArrayBufferStream.toByteArray();
        JkUtilsIO.write(JkMemoryBufferLogDecorator.jkLogInstance.delegate.getTargetOut(), bytes);
    }

    private static ByteArrayOutputStream byteArrayBufferStream() {
        return new ByteArrayOutputStream();
    }
}

