/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JkProcess<T extends JkProcess>
implements Runnable,
Cloneable {
    private static final Path CURRENT_JAVA_DIR = Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin");
    private String command;
    private List<String> parameters;
    private Map<String, String> env = new HashMap<String, String>();
    private Path workingDir;
    private boolean failOnError;
    private boolean logCommand;
    private boolean logOutput = true;

    protected JkProcess(String command, String ... parameters) {
        this.command = command;
        this.parameters = new LinkedList<String>(Arrays.asList(parameters));
    }

    public static JkProcess<JkProcess> of(String command, String ... parameters) {
        return new JkProcess<JkProcess>(command, parameters);
    }

    public static JkProcess<JkProcess> ofCmdLine(String commandLine) {
        String[] items = JkUtilsString.translateCommandline(commandLine);
        JkUtilsAssert.argument(items.length > 0, "Cannot accept empty command line.", new Object[0]);
        String cmd = items[0];
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(items));
        args.remove(0);
        return new JkProcess<JkProcess>(cmd, args.toArray(new String[0]));
    }

    public static JkProcess<JkProcess> ofWinOrUx(String windowsCommand, String unixCommand, String ... parameters) {
        String cmd = JkUtilsSystem.IS_WINDOWS ? windowsCommand : unixCommand;
        return new JkProcess<JkProcess>(cmd, parameters);
    }

    public static JkProcess ofJavaTool(String javaTool, String ... parameters) {
        Path candidate = CURRENT_JAVA_DIR;
        boolean exist = JkProcess.findTool(candidate, javaTool);
        if (!exist && !JkProcess.findTool(candidate = CURRENT_JAVA_DIR.getParent().getParent().resolve("bin"), javaTool)) {
            throw new IllegalArgumentException("No tool " + javaTool + " found neither in " + CURRENT_JAVA_DIR + " nor in " + candidate);
        }
        String command = candidate.toAbsolutePath().normalize().resolve(javaTool).toString();
        return JkProcess.of(command, parameters);
    }

    public T clone() {
        try {
            JkProcess clone = (JkProcess)super.clone();
            clone.parameters = new LinkedList<String>(this.parameters);
            clone.env = new HashMap<String, String>(this.env);
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public T setCommand(String command) {
        this.command = command;
        return (T)this;
    }

    public T addParams(String ... parameters) {
        return this.addParams(Arrays.asList(parameters));
    }

    public T removeParam(String parameter) {
        this.parameters.remove(parameter);
        return (T)this;
    }

    public T addParamsIf(boolean condition, String ... parameters) {
        if (condition) {
            return this.addParams(parameters);
        }
        return (T)this;
    }

    public T addParams(Collection<String> parameters) {
        LinkedList<String> params = new LinkedList<String>(parameters);
        params.removeAll(Collections.singleton(null));
        this.parameters.addAll(params);
        return (T)this;
    }

    public T addParamsFirst(Collection<String> parameters) {
        LinkedList<String> params = new LinkedList<String>(parameters);
        params.removeAll(Collections.singleton(null));
        this.parameters.addAll(0, params);
        return (T)this;
    }

    public T addParamsFirst(String ... parameters) {
        return this.addParamsFirst(Arrays.asList(parameters));
    }

    public T setWorkingDir(Path workingDir) {
        this.workingDir = workingDir;
        return (T)this;
    }

    public T setEnv(String name, String value) {
        this.env.put(name, value);
        return (T)this;
    }

    public T setWorkingDir(String workingDir) {
        return this.setWorkingDir(Paths.get(workingDir, new String[0]));
    }

    public T setFailOnError(boolean fail) {
        this.failOnError = fail;
        return (T)this;
    }

    public T setLogCommand(boolean logCommand) {
        this.logCommand = logCommand;
        return (T)this;
    }

    public T setLogOutput(boolean logOutput) {
        this.logOutput = logOutput;
        return (T)this;
    }

    public T inheritJkLogOptions() {
        if (JkLog.getDecoratorStyle() != null) {
            this.addParams("-ls=" + JkLog.getDecoratorStyle().name());
        }
        if (JkLog.isVerbose()) {
            this.addParams("-lv");
        }
        if (!JkLog.isAcceptAnimation()) {
            this.addParams("-lna");
        }
        return (T)this;
    }

    public void execIf(boolean condition, String ... extraParams) {
        if (condition) {
            this.exec(new String[0]);
        }
    }

    public int exec(String ... extraParams) {
        if (extraParams.length == 1) {
            extraParams = JkUtilsString.translateCommandline(extraParams[0]);
        }
        return this.exec((boolean)false, (String[])extraParams).exitCode;
    }

    public List<String> execAndReturnOutput(String ... extraParams) {
        Result result = this.exec(true, extraParams);
        if (result.output.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(result.output.split("\\r?\n"));
    }

    private Result exec(boolean collectOutput, String ... extraParams) {
        OutputStream collectOs;
        JkUtilsAssert.state(!JkUtilsString.isBlank(this.command), "No command has been specified", new Object[0]);
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(this.command);
        commands.addAll(this.parameters);
        commands.addAll(Arrays.asList(extraParams));
        commands.removeAll(Collections.singleton(null));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = collectOs = collectOutput ? byteArrayOutputStream : JkUtilsIO.nopOuputStream();
        if (this.logCommand) {
            String workingDirName = this.workingDir == null ? "" : this.workingDir.toString() + ">";
            JkLog.startTask("Start program : " + workingDirName + ((Object)commands).toString(), new Object[0]);
        }
        int exitCode = this.runProcess(commands, collectOs);
        if (this.logCommand) {
            JkLog.endTask();
        }
        Result out = new Result();
        out.exitCode = exitCode;
        out.output = collectOutput ? new String(byteArrayOutputStream.toByteArray()) : null;
        return out;
    }

    private int runProcess(List<String> commands, OutputStream collectOs) {
        int exitCode;
        Process process;
        ProcessBuilder processBuilder = this.processBuilder(commands);
        if (this.workingDir != null) {
            processBuilder.directory(this.workingDir.toAbsolutePath().normalize().toFile());
        }
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        OutputStream consoleOutputStream = this.logOutput ? JkLog.getOutPrintStream() : JkUtilsIO.nopOuputStream();
        OutputStream consoleErrStream = this.logOutput ? JkLog.getErrPrintStream() : JkUtilsIO.nopOuputStream();
        JkUtilsIO.JkStreamGobbler outputStreamGobbler = JkUtilsIO.newStreamGobbler(process.getInputStream(), consoleOutputStream, collectOs);
        JkUtilsIO.JkStreamGobbler errorStreamGobbler = JkUtilsIO.newStreamGobbler(process.getErrorStream(), consoleErrStream, collectOs);
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        outputStreamGobbler.join();
        errorStreamGobbler.join();
        if (exitCode != 0 && this.failOnError) {
            throw new IllegalStateException("Process " + String.join((CharSequence)" ", JkProcess.elipsed(commands)) + "\nhas returned with error code " + exitCode);
        }
        return exitCode;
    }

    private static List<String> elipsed(List<String> options) {
        if (JkLog.isVerbose()) {
            return options;
        }
        return options.stream().map(option -> JkUtilsString.elipse(option, 120)).collect(Collectors.toList());
    }

    private ProcessBuilder processBuilder(List<String> command) {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        builder.environment().putAll(this.env);
        if (this.workingDir != null) {
            builder.directory(this.workingDir.toAbsolutePath().normalize().toFile());
        }
        return builder;
    }

    private static boolean findTool(Path dir, String name) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return false;
        }
        for (Path file : JkUtilsPath.listDirectChildren(dir)) {
            if (Files.isDirectory(file, new LinkOption[0])) continue;
            if (file.getFileName().toString().equals(name)) {
                return true;
            }
            String fileToolName = JkUtilsString.substringBeforeLast(file.getFileName().toString(), ".");
            if (!fileToolName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.exec(new String[0]);
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getParams() {
        return Collections.unmodifiableList(this.parameters);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public String toString() {
        return this.command + " " + String.join((CharSequence)" ", this.parameters);
    }

    private static class Result {
        int exitCode;
        String output;

        private Result() {
        }
    }
}

