/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.testing;

import dev.jeka.core.api.depmanagement.JkModuleFileProxy;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.function.JkRunnables;
import dev.jeka.core.api.function.JkUnaryOperator;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkClasspath;
import dev.jeka.core.api.java.JkJavaProcess;
import dev.jeka.core.api.java.JkUrlClassLoader;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.testing.JkInternalJunitDoer;
import dev.jeka.core.api.testing.JkTestResult;
import dev.jeka.core.api.testing.JkTestSelection;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.junit.platform.launcher.core.LauncherConfig;

public final class JkTestProcessor<T> {
    private static final String JAR_LOCATION = "META-INF/junitplatform/";
    private static final String ENGINE_SERVICE = "org.junit.platform.engine.TestEngine";
    private static final String PLATFORM_LAUNCHER_CLASS_NAME = "org.junit.platform.launcher.Launcher";
    private static final String PLATFORM_COMMONS_CLASS_NAME = "org.junit.platform.commons.util.ClassNamePatternFilterUtils";
    private static final String PLATFORM_ENGINE_CLASS_NAME = "org.junit.platform.engine.EngineDiscoveryListener";
    private static final String PLATFORM_REPORT_CLASS_NAME = "org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener";
    private static final String OPENTEST4J_CLASS_NAME = "org.opentest4j.ValueWrapper";
    private static final String JUNIT_PLATFORM_LAUNCHER_MODULE = "org.junit.platform:junit-platform-launcher";
    private static final String JUNIT_PLATFORM_REPORTING_MODULE = "org.junit.platform:junit-platform-reporting";
    private JkJavaProcess forkingProcess = JkJavaProcess.ofJava(JkTestProcessor.class.getName());
    private JkEngineBehavior<T> engineBehavior;
    private final JkRunnables preActions = JkRunnables.of();
    private final JkRunnables postActions = JkRunnables.of();
    private String junitPlatformVersion = "1.8.2";
    private Supplier<JkRepoSet> repoSetSupplier;
    public final transient T __;

    private JkTestProcessor(T __) {
        this.__ = __;
    }

    public static JkTestProcessor<Void> of() {
        return JkTestProcessor.ofParent(null);
    }

    public static <T> JkTestProcessor<T> ofParent(T parent) {
        JkTestProcessor<T> result = new JkTestProcessor<T>(parent);
        result.engineBehavior = new JkEngineBehavior(result);
        return result;
    }

    public JkJavaProcess getForkingProcess() {
        return this.forkingProcess;
    }

    public JkEngineBehavior<T> getEngineBehavior() {
        return this.engineBehavior;
    }

    public JkRunnables getPreActions() {
        return this.preActions;
    }

    public JkRunnables getPostActions() {
        return this.postActions;
    }

    public JkTestProcessor<T> setForkingProcess(JkJavaProcess process) {
        this.forkingProcess = process;
        return this;
    }

    public JkTestProcessor<T> setForkingProcess(boolean fork) {
        if (fork) {
            if (this.forkingProcess != null) {
                return this;
            }
            this.forkingProcess = JkJavaProcess.ofJava(JkTestProcessor.class.getName());
        } else {
            this.forkingProcess = null;
        }
        return this;
    }

    public String getJunitPlatformVersion() {
        return this.junitPlatformVersion;
    }

    public JkTestProcessor<T> setJunitPlatformVersion(String junitPlatformVersion) {
        this.junitPlatformVersion = junitPlatformVersion;
        return this;
    }

    public JkTestProcessor<T> setRepoSetSupplier(Supplier<JkRepoSet> repoSetSupplier) {
        this.repoSetSupplier = repoSetSupplier;
        return this;
    }

    private List<Path> computeClasspath(JkPathSequence testClasspath) {
        JkClasspath result = JkClasspath.of(testClasspath);
        JkClassLoader classloader = JkClassLoader.ofCurrent();
        result = this.addIfNeeded(result, classloader, PLATFORM_LAUNCHER_CLASS_NAME, JUNIT_PLATFORM_LAUNCHER_MODULE);
        result = this.addIfNeeded(result, classloader, PLATFORM_REPORT_CLASS_NAME, JUNIT_PLATFORM_REPORTING_MODULE);
        JkUrlClassLoader ucl = JkUrlClassLoader.of(result, classloader.get());
        Class testEngineClass = ucl.toJkClassLoader().load(ENGINE_SERVICE);
        return result.getEntries();
    }

    private JkClasspath addIfNeeded(JkClasspath classpath, JkClassLoader classloader, String className, String moduleName) {
        JkClasspath result = classpath;
        if (!classloader.isDefined(className) && result.getEntryContainingClass(className) == null) {
            String dep = moduleName + ":" + this.junitPlatformVersion;
            Path path = JkModuleFileProxy.of(this.repoSetSupplier.get(), dep).get();
            result = result.and(path);
        }
        return result;
    }

    public JkTestResult launch(JkPathSequence extraTestClasspath, JkTestSelection testSelection) {
        JkTestResult result;
        if (!testSelection.hasTestClasses()) {
            JkLog.trace("No test class found in %s. No test to run.", testSelection.getTestClassRoots());
            return JkTestResult.of();
        }
        this.preActions.run();
        if (this.forkingProcess == null) {
            JkLog.startTask("Executing tests", new Object[0]);
            result = this.launchInClassloader(extraTestClasspath, testSelection);
        } else {
            JkLog.startTask("Execute tests in forked process", new Object[0]);
            result = this.launchInForkedProcess(extraTestClasspath, testSelection);
        }
        this.postActions.run();
        JkLog.info("Result : " + result.getTestCount(), new Object[0]);
        JkLog.endTask();
        return result;
    }

    private JkTestResult launchInClassloader(JkPathSequence testClasspath, JkTestSelection testSelection) {
        List<Path> classpath = this.computeClasspath(testClasspath);
        return JkInternalJunitDoer.instance(classpath).launch(this.engineBehavior, testSelection);
    }

    private JkTestResult launchInForkedProcess(JkPathSequence testClasspath, JkTestSelection testSelection) {
        Path serializedResultPath = JkUtilsPath.createTempFile("testResult-", ".ser", new FileAttribute[0]);
        Args args = new Args();
        args.resultFile = serializedResultPath.toAbsolutePath().toString();
        args.engineBehavior = this.engineBehavior;
        args.testSelection = testSelection;
        Path serializedArgPath = JkUtilsPath.createTempFile("testArgs-", ".ser", new FileAttribute[0]);
        JkUtilsIO.serialize((Object)args, serializedArgPath);
        String arg = serializedArgPath.toAbsolutePath().toString();
        List<Path> classapth = JkClassLoader.ofCurrent().getClasspath().and(this.computeClasspath(testClasspath)).withoutDuplicates().getEntries();
        ((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)((JkJavaProcess)this.forkingProcess.clone()).setLogCommand(false)).setFailOnError(true)).setClasspath(classapth).addParams(arg)).exec(new String[0]);
        JkUtilsPath.deleteFile(serializedArgPath);
        JkTestResult result = (JkTestResult)JkUtilsIO.deserialize(serializedResultPath);
        JkUtilsPath.deleteFile(serializedResultPath);
        return result;
    }

    public static void main(String[] args) {
        Path argFile = Paths.get(args[0], new String[0]);
        Args data = (Args)JkUtilsIO.deserialize(argFile);
        JkTestResult result = JkInternalJunitDoer.instance(Collections.emptyList()).launch(data.engineBehavior, data.testSelection);
        JkUtilsIO.serialize((Object)result, Paths.get(data.resultFile, new String[0]));
        System.exit(0);
    }

    public static class JkEngineBehavior<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final transient JkTestProcessor<T> __;
        private String legacyReportDir;
        private JkProgressOutputStyle progressDisplayer;
        private JkUnaryOperator<LauncherConfig.Builder> launcherConfigurer;

        private JkEngineBehavior(JkTestProcessor<T> __) {
            this.__ = __;
        }

        public Path getLegacyReportDir() {
            return this.legacyReportDir == null ? null : Paths.get(this.legacyReportDir, new String[0]);
        }

        public JkProgressOutputStyle getProgressDisplayer() {
            return this.progressDisplayer;
        }

        public JkUnaryOperator<LauncherConfig.Builder> getLauncherConfigurer() {
            return this.launcherConfigurer;
        }

        public JkEngineBehavior<T> setLegacyReportDir(Path legacyReportDir) {
            this.legacyReportDir = legacyReportDir == null ? null : legacyReportDir.toString();
            return this;
        }

        public JkEngineBehavior<T> setProgressDisplayer(JkProgressOutputStyle progressDisplayer) {
            this.progressDisplayer = progressDisplayer;
            return this;
        }

        public JkEngineBehavior<T> setLauncherConfigurer(JkUnaryOperator<LauncherConfig.Builder> launcherConfigurer) {
            this.launcherConfigurer = launcherConfigurer;
            return this;
        }
    }

    private static class Args
    implements Serializable {
        private static final long serialVersionUID = 1L;
        JkEngineBehavior engineBehavior;
        String resultFile;
        JkTestSelection testSelection;

        private Args() {
        }
    }

    public static enum JkProgressOutputStyle implements Serializable
    {
        FULL,
        TREE,
        ONE_LINE,
        SILENT,
        BAR;

    }
}

