/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.testing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class JkTestResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long timeStarted;
    private final long timeFinished;
    private final JkCount containerCount;
    private final JkCount testCount;
    private final List<JkFailure> failures;

    private JkTestResult(long timeStarted, long timeFinished, JkCount containerCount, JkCount testCount, List<JkFailure> failures) {
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.containerCount = containerCount;
        this.testCount = testCount;
        this.failures = failures;
    }

    public static JkTestResult of(long timeStarted, long timeFinished, JkCount containerCount, JkCount testCount, List<JkFailure> failures) {
        return new JkTestResult(timeStarted, timeFinished, containerCount, testCount, failures);
    }

    public static JkTestResult of() {
        return JkTestResult.of(System.currentTimeMillis(), System.currentTimeMillis(), JkCount.of(), JkCount.of(), Collections.emptyList());
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public long getTimeFinished() {
        return this.timeFinished;
    }

    public JkCount getContainerCount() {
        return this.containerCount;
    }

    public JkCount getTestCount() {
        return this.testCount;
    }

    public List<JkFailure> getFailures() {
        return this.failures;
    }

    public String toString() {
        return "{timeStarted=" + this.timeStarted + ", timeFinished=" + this.timeFinished + ", containerCount=" + this.containerCount + ", testCount=" + this.testCount + ", failures=" + this.failures + '}';
    }

    public void printFailures(PrintStream printStream) {
        for (JkFailure failure : this.failures) {
            failure.print(printStream);
            printStream.println();
        }
    }

    public void assertNoFailure() {
        if (this.failures.isEmpty()) {
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                try {
                    PrintStream printStream = new PrintStream(os);
                    printStream.println("" + this.failures.size() + " test failures : ");
                    printStream.println();
                    this.printFailures(printStream);
                    String message = os.toString("UTF8");
                    throw new IllegalStateException(message);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (os != null) {
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        os.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final class JkTestIdentifier
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JkType type;
        private final String id;
        private final String displayName;
        private final Set<String> tags;

        private JkTestIdentifier(JkType type, String id, String displayName, Set<String> tags) {
            this.type = type;
            this.id = id;
            this.displayName = displayName;
            this.tags = tags;
        }

        public static JkTestIdentifier of(JkType type, String id, String displayName, Set<String> tags) {
            return new JkTestIdentifier(type, id, displayName, tags);
        }

        public JkType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public String toString() {
            return "{type=" + (Object)((Object)this.type) + ", id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", tags=" + this.tags + '}';
        }

        public static enum JkType {
            TEST,
            CONTAINER,
            CONTAINER_AND_TEST;

        }
    }

    public static final class JkFailure
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JkTestIdentifier testId;
        private final String throwableMessage;
        private final StackTraceElement[] tacktraces;

        private JkFailure(JkTestIdentifier testId, String throwableMessage, StackTraceElement[] tacktraces) {
            this.testId = testId;
            this.throwableMessage = throwableMessage;
            this.tacktraces = tacktraces;
        }

        public static JkFailure of(JkTestIdentifier testId, String throwableMessage, StackTraceElement[] stacktraces) {
            return new JkFailure(testId, throwableMessage, stacktraces);
        }

        public JkTestIdentifier getTestId() {
            return this.testId;
        }

        public String getThrowableMessage() {
            return this.throwableMessage;
        }

        public StackTraceElement[] getTacktraces() {
            return this.tacktraces;
        }

        public String toString() {
            System.out.println();
            return "{testId=" + this.testId + ", throwableMessage='" + this.throwableMessage + '\'' + ", tacktraces=" + Arrays.toString(this.tacktraces) + '}';
        }

        void print(PrintStream printStream) {
            printStream.print(this.testId + System.lineSeparator() + "-> ");
            printStream.println(this.throwableMessage);
            for (StackTraceElement element : this.getTacktraces()) {
                printStream.println("  at " + element);
            }
        }
    }

    public static class JkCount
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long found;
        private final long started;
        private final long skipped;
        private final long aborted;
        private final long succeded;
        private final long failed;

        private JkCount(long found, long started, long skipped, long aborted, long succeded, long failed) {
            this.found = found;
            this.started = started;
            this.skipped = skipped;
            this.aborted = aborted;
            this.succeded = succeded;
            this.failed = failed;
        }

        public static JkCount of(long found, long started, long skipped, long aborted, long succeded, long failed) {
            return new JkCount(found, started, skipped, aborted, succeded, failed);
        }

        private static JkCount of() {
            return new JkCount(0L, 0L, 0L, 0L, 0L, 0L);
        }

        public long getFound() {
            return this.found;
        }

        public long getStarted() {
            return this.started;
        }

        public long getSkipped() {
            return this.skipped;
        }

        public long getAborted() {
            return this.aborted;
        }

        public long getSucceded() {
            return this.succeded;
        }

        public long getFailed() {
            return this.failed;
        }

        public String toString() {
            return "{found=" + this.found + ", started=" + this.started + ", skipped=" + this.skipped + ", aborted=" + this.aborted + ", succeded=" + this.succeded + ", failed=" + this.failed + '}';
        }
    }
}

