/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling;

import dev.jeka.core.api.depmanagement.JkDependencyExclusion;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.utils.JkUtilsIterable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DependencyExclusions {
    private final Map<JkModuleId, List<JkDependencyExclusion>> exclusions;

    private DependencyExclusions(Map<JkModuleId, List<JkDependencyExclusion>> exclusions) {
        this.exclusions = Collections.unmodifiableMap(exclusions);
    }

    public static DependencyExclusions of() {
        return new DependencyExclusions(Collections.emptyMap());
    }

    public Set<JkModuleId> getModuleIds() {
        return this.exclusions.keySet();
    }

    public List<JkDependencyExclusion> get(JkModuleId moduleId) {
        return this.exclusions.get(moduleId);
    }

    public boolean isEmpty() {
        return this.exclusions.isEmpty();
    }

    public DependencyExclusions and(String groupAndName, String ... excludedModuleIds) {
        return this.and(JkModuleId.of(groupAndName), excludedModuleIds);
    }

    public DependencyExclusions and(JkModuleId moduleId, String ... excludedModuleIds) {
        LinkedList<JkDependencyExclusion> depExcludes = new LinkedList<JkDependencyExclusion>();
        for (String excludeId : excludedModuleIds) {
            depExcludes.add(JkDependencyExclusion.of(excludeId));
        }
        return this.and(moduleId, depExcludes);
    }

    public DependencyExclusions and(JkModuleId moduleId, Iterable<JkDependencyExclusion> depExcludes) {
        List<JkDependencyExclusion> excludes = this.exclusions.get(moduleId);
        if (excludes == null) {
            excludes = new LinkedList<JkDependencyExclusion>();
        }
        excludes.addAll(JkUtilsIterable.listOf(depExcludes));
        HashMap<JkModuleId, List<JkDependencyExclusion>> map = new HashMap<JkModuleId, List<JkDependencyExclusion>>(this.exclusions);
        map.put(moduleId, excludes);
        return new DependencyExclusions(map);
    }
}

