/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling;

import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public final class JkGitProcess
extends JkProcess<JkGitProcess> {
    private JkGitProcess() {
        super("git", new String[0]);
    }

    public static JkGitProcess of(Path dir) {
        return (JkGitProcess)new JkGitProcess().setWorkingDir(dir);
    }

    public static JkGitProcess of(String dir) {
        return JkGitProcess.of(Paths.get(dir, new String[0]));
    }

    public static JkGitProcess of() {
        return JkGitProcess.of("");
    }

    public String getCurrentBranch() {
        return ((JkGitProcess)((JkGitProcess)((JkGitProcess)this.clone()).addParams("rev-parse", "--abbrev-ref", "HEAD")).setLogOutput(false)).execAndReturnOutput(new String[0]).get(0);
    }

    public boolean isRemoteEqual() {
        List<String> local = ((JkGitProcess)((JkGitProcess)this.clone()).addParams("rev-parse", "@")).execAndReturnOutput(new String[0]);
        List<String> remote = ((JkGitProcess)((JkGitProcess)this.clone()).addParams("rev-parse", "@{u}")).execAndReturnOutput(new String[0]);
        return ((Object)local).equals(remote);
    }

    public boolean isWorkspaceDirty() {
        return !((JkGitProcess)((JkGitProcess)((JkGitProcess)this.clone()).addParams("diff", "HEAD", "--stat")).setLogOutput(false)).execAndReturnOutput(new String[0]).isEmpty();
    }

    public String getCurrentCommit() {
        return ((JkGitProcess)((JkGitProcess)((JkGitProcess)this.clone()).addParams("rev-parse", "HEAD")).setLogOutput(false)).execAndReturnOutput(new String[0]).get(0);
    }

    public List<String> getTagsOfCurrentCommit() {
        return ((JkGitProcess)((JkGitProcess)((JkGitProcess)this.clone()).addParams("tag", "-l", "--points-at", "HEAD")).setLogOutput(false)).execAndReturnOutput(new String[0]);
    }

    public List<String> getLastCommitMessage() {
        return ((JkGitProcess)((JkGitProcess)((JkGitProcess)this.clone()).addParams("log", "--oneline", "--format=%B", "-n 1", "HEAD")).setLogOutput(false)).execAndReturnOutput(new String[0]);
    }

    public String extractSuffixFromLastCommitMessage(String prefix) {
        String[] words;
        List<String> messageLines = this.getLastCommitMessage();
        if (messageLines.isEmpty()) {
            return null;
        }
        for (String word : words = messageLines.get(0).split(" ")) {
            if (!word.startsWith(prefix)) continue;
            return word.substring(prefix.length());
        }
        return null;
    }

    public JkGitProcess tagAndPush(String name) {
        this.tag(name);
        ((JkGitProcess)((JkGitProcess)this.clone()).addParams("push", "origin", name)).exec(new String[0]);
        return this;
    }

    public JkGitProcess tag(String name) {
        ((JkGitProcess)((JkGitProcess)this.clone()).addParams("tag", name)).exec(new String[0]);
        return this;
    }

    public String getVersionFromCommitMessage(String prefixKeyword) {
        String afterSuffix = this.extractSuffixFromLastCommitMessage(prefixKeyword);
        if (afterSuffix != null) {
            return afterSuffix;
        }
        try {
            String branch = this.getCurrentBranch();
            return branch + "-SNAPSHOT";
        }
        catch (IllegalStateException e) {
            JkLog.warn(e.getMessage(), new Object[0]);
            return JkVersion.UNSPECIFIED.getValue();
        }
    }

    public String getVersionFromTag() {
        return this.getVersionFromTag("");
    }

    public String getVersionFromTag(String prefix) {
        boolean dirty;
        String branch;
        List tags;
        try {
            tags = this.getTagsOfCurrentCommit().stream().filter(tag -> tag.startsWith(prefix)).collect(Collectors.toList());
            branch = this.getCurrentBranch();
            dirty = this.isWorkspaceDirty();
        }
        catch (IllegalStateException e) {
            JkLog.warn(e.getMessage(), new Object[0]);
            return JkVersion.UNSPECIFIED.getValue();
        }
        if (tags.isEmpty() || dirty) {
            return branch + "-SNAPSHOT";
        }
        return (String)tags.get(tags.size() - 1);
    }

    public JkVersion getJkVersionFromTag() {
        return JkVersion.of(this.getVersionFromTag());
    }
}

