/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling;

import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkQualifiedDependency;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.tooling.JkPom;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;

public final class JkMvn
implements Runnable {
    private static final String MVN_CMD = JkMvn.mvnCmd();
    public static final boolean INSTALLED = MVN_CMD != null;
    private final JkProcess jkProcess;

    private static String mvnCmd() {
        if (JkUtilsSystem.IS_WINDOWS) {
            if (JkMvn.exist("mvn.bat")) {
                return "mvn.bat";
            }
            if (JkMvn.exist("mvn.cmd")) {
                return "mvn.cmd";
            }
            return null;
        }
        if (JkMvn.exist("mvn")) {
            return "mvn";
        }
        return null;
    }

    private static boolean exist(String cmd) {
        try {
            int result = Runtime.getRuntime().exec(cmd + " -version").waitFor();
            return result == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JkMvn of(Path workingDir, String ... args) {
        if (MVN_CMD == null) {
            throw new IllegalStateException("Maven not installed on this machine");
        }
        JkProcess jkProcess = JkProcess.of(MVN_CMD, args).setWorkingDir(workingDir);
        return new JkMvn(jkProcess);
    }

    private JkMvn(JkProcess jkProcess) {
        this.jkProcess = jkProcess;
    }

    public final JkMvn commands(String ... args) {
        return new JkMvn((JkProcess)this.jkProcess.addParams(args));
    }

    public final JkMvn cleanPackage() {
        return this.commands("deleteArtifacts", "package");
    }

    public final JkMvn cleanInstall() {
        return this.commands("deleteArtifacts", "install");
    }

    public JkQualifiedDependencySet readDependencies() {
        Path file = JkUtilsPath.createTempFile("dependency", ".txt", new FileAttribute[0]);
        this.commands("dependency:list", "-DoutputFile=" + file).run();
        JkQualifiedDependencySet result = JkMvn.fromMvnFlatFile(file);
        JkUtilsPath.deleteFile(file);
        return result;
    }

    public final JkMvn withForceUpdate(boolean flag) {
        if (flag) {
            return new JkMvn((JkProcess)this.jkProcess.addParams("-U"));
        }
        return new JkMvn((JkProcess)this.jkProcess.removeParam("-U"));
    }

    public final JkMvn withVerbose(boolean flag) {
        if (flag) {
            return new JkMvn((JkProcess)this.jkProcess.addParams("-X"));
        }
        return new JkMvn((JkProcess)this.jkProcess.removeParam("-X"));
    }

    public JkProcess toProcess() {
        return this.jkProcess;
    }

    @Override
    public void run() {
        this.jkProcess.exec(new String[0]);
    }

    public static JkQualifiedDependencySet fromMvnFlatFile(Path flatFile) {
        LinkedList<JkQualifiedDependency> result = new LinkedList<JkQualifiedDependency>();
        for (String line : JkUtilsPath.readAllLines(flatFile)) {
            JkQualifiedDependency scopedDependency = JkMvn.mvnDep(line);
            if (scopedDependency == null) continue;
            result.add(scopedDependency);
        }
        return JkQualifiedDependencySet.of(result);
    }

    private static JkQualifiedDependency mvnDep(String description) {
        String[] items = description.trim().split(":");
        if (items.length == 5) {
            String classifier = items[2];
            String scope = JkPom.toScope(items[4]);
            JkModuleDependency dependency = JkModuleDependency.of(items[0], items[1], items[3]);
            if (!"jar".equals(classifier)) {
                dependency = dependency.withClassifiers(classifier);
            }
            return JkQualifiedDependency.of(scope, dependency);
        }
        if (items.length == 4) {
            String scope = JkPom.toScope(items[3]);
            JkModuleDependency dependency = JkModuleDependency.of(items[0], items[1], items[2]);
            return JkQualifiedDependency.of(scope, dependency);
        }
        if (items.length == 3) {
            JkModuleDependency dependency = JkModuleDependency.of(items[0], items[1], items[2]);
            return JkQualifiedDependency.of(null, dependency);
        }
        return null;
    }
}

