/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling;

import dev.jeka.core.api.depmanagement.JkDependencyExclusion;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkQualifiedDependency;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.tooling.DependencyExclusions;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsXml;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JkPom {
    private static final List<String> KNOWN_SCOPE = JkUtilsIterable.listOf("compile", "runtime", "provided", "test");
    private final Document pomDoc;

    private JkPom(Document pomDoc) {
        this.pomDoc = pomDoc;
    }

    public static JkPom of(Path file) {
        Document document = JkUtilsXml.documentFrom(file);
        return new JkPom(document);
    }

    private Element propertiesEl() {
        return JkUtilsXml.directChild(this.projectEl(), "properties");
    }

    private Element dependenciesElement() {
        return JkUtilsXml.directChild(this.projectEl(), "dependencies");
    }

    private Element dependencyManagementEl() {
        return JkUtilsXml.directChild(this.projectEl(), "dependencyManagement");
    }

    private Element repositoriesEl() {
        return JkUtilsXml.directChild(this.projectEl(), "repositories");
    }

    private Element projectEl() {
        return this.pomDoc.getDocumentElement();
    }

    public String getGroupId() {
        return JkUtilsXml.directChildText(this.projectEl(), "groupId");
    }

    public String getArtifactId() {
        return JkUtilsXml.directChildText(this.projectEl(), "artifactId");
    }

    public String getVersion() {
        return JkUtilsXml.directChildText(this.projectEl(), "version");
    }

    public JkQualifiedDependencySet getDependencies() {
        Element dependenciesEl = this.dependenciesElement();
        if (dependenciesEl == null) {
            return JkQualifiedDependencySet.of();
        }
        return this.dependencies(dependenciesEl, this.getProperties());
    }

    public JkVersionProvider getVersionProvider() {
        LinkedList<JkVersionedModule> versionedModules = new LinkedList<JkVersionedModule>();
        Element dependencyManagementEl = this.dependencyManagementEl();
        if (dependencyManagementEl == null) {
            return JkVersionProvider.of();
        }
        Element dependenciesEl = JkUtilsXml.directChild(dependencyManagementEl, "dependencies");
        if (dependenciesEl == null) {
            return JkVersionProvider.of();
        }
        JkQualifiedDependencySet scopedDependencies = this.dependencies(dependenciesEl, this.getProperties());
        for (JkModuleDependency moduleDependency : scopedDependencies.getModuleDependencies()) {
            JkVersionedModule versionedModule = JkVersionedModule.of(moduleDependency.getModuleId(), JkVersion.of(moduleDependency.getVersion().getValue()));
            versionedModules.add(versionedModule);
        }
        return JkVersionProvider.of(versionedModules);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.propertiesEl() == null) {
            return result;
        }
        NodeList nodeList = this.propertiesEl().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            result.put(element.getTagName(), element.getTextContent());
        }
        JkPom.interpolate(result, 0);
        return result;
    }

    private static void interpolate(Map<String, String> map, int count) {
        boolean found = false;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            for (String key : map.keySet()) {
                String token = "${" + key + "}";
                if (!value.contains(token)) continue;
                found = true;
                String interpolatedValue = map.get(key);
                String newValue = value.replace(token, interpolatedValue);
                map.put(entry.getKey(), newValue);
            }
        }
        if (count < 10 && found) {
            JkPom.interpolate(map, count + 1);
        }
    }

    public DependencyExclusions getDependencyExclusion() {
        DependencyExclusions result = DependencyExclusions.of();
        Element dependencyManagementEl = this.dependencyManagementEl();
        if (dependencyManagementEl == null) {
            return result;
        }
        Element dependenciesEl = JkUtilsXml.directChild(dependencyManagementEl, "dependencies");
        if (dependenciesEl == null) {
            return result;
        }
        JkQualifiedDependencySet scopedDependencies = this.dependencies(dependenciesEl, this.getProperties());
        for (JkModuleDependency moduleDependency : scopedDependencies.getModuleDependencies()) {
            if (moduleDependency.getExclusions().isEmpty()) continue;
            result = result.and(moduleDependency.getModuleId(), moduleDependency.getExclusions());
        }
        return result;
    }

    public JkRepoSet getRepos() {
        LinkedList<String> urls = new LinkedList<String>();
        if (this.repositoriesEl() == null) {
            return JkRepoSet.of(new String[0]);
        }
        for (Element repositoryEl : JkUtilsXml.directChildren(this.repositoriesEl(), "repository")) {
            urls.add(JkUtilsXml.directChildText(repositoryEl, "url"));
        }
        return JkRepoSet.of(JkUtilsIterable.arrayOf(urls, String.class));
    }

    private JkQualifiedDependencySet dependencies(Element dependenciesEl, Map<String, String> props) {
        LinkedList<JkQualifiedDependency> scopedDependencies = new LinkedList<JkQualifiedDependency>();
        for (Element dependencyEl : JkUtilsXml.directChildren(dependenciesEl, "dependency")) {
            scopedDependencies.add(this.scopedDep(dependencyEl, props));
        }
        return JkQualifiedDependencySet.of(scopedDependencies);
    }

    private JkQualifiedDependency scopedDep(Element mvnDependency, Map<String, String> props) {
        Element exclusionsEl;
        String groupId = JkUtilsXml.directChildText(mvnDependency, "groupId");
        String artifactId = JkUtilsXml.directChildText(mvnDependency, "artifactId");
        String version = JkPom.resolveProps(JkUtilsXml.directChildText(mvnDependency, "version"), props);
        JkModuleDependency moduleDependency = JkModuleDependency.of(groupId, artifactId, version);
        String type = JkUtilsXml.directChildText(mvnDependency, "type");
        String classifier = JkUtilsXml.directChildText(mvnDependency, "classifier");
        if (type != null || classifier != null) {
            moduleDependency = moduleDependency.andClassifierAndType(classifier, type);
        }
        if ((exclusionsEl = JkUtilsXml.directChild(mvnDependency, "exclusions")) != null) {
            for (Element exclusionElement : JkUtilsXml.directChildren(exclusionsEl, "exclusion")) {
                moduleDependency = moduleDependency.andExclusion(this.jkDepExclude(exclusionElement));
            }
        }
        String scope = JkUtilsXml.directChildText(mvnDependency, "scope");
        scope = JkUtilsObject.firstNonNull(scope, "compile");
        String realScope = JkPom.toScope(scope);
        return JkQualifiedDependency.of(realScope, moduleDependency);
    }

    private JkDependencyExclusion jkDepExclude(Element exclusionEl) {
        String groupId = JkUtilsXml.directChildText(exclusionEl, "groupId");
        String artifactId = JkUtilsXml.directChildText(exclusionEl, "artifactId");
        return JkDependencyExclusion.of(groupId, artifactId);
    }

    private static String resolveProps(String value, Map<String, String> props) {
        String varName;
        String varValue;
        if (JkUtilsString.isBlank(value)) {
            return value;
        }
        if (value.startsWith("${") && value.endsWith("}") && (varValue = props.get(varName = value.substring(2, value.length() - 1))) != null) {
            return varValue;
        }
        return value;
    }

    static String toScope(String candidate) {
        if (candidate == null) {
            return null;
        }
        String normalized = candidate.trim().toLowerCase();
        if (KNOWN_SCOPE.contains(normalized)) {
            return candidate;
        }
        return null;
    }
}

