/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;

public final class JkUtilsIO {
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);

    private JkUtilsIO() {
    }

    public static PrintStream nopPrintStream() {
        return new PrintStream(JkUtilsIO.nopOuputStream());
    }

    public static OutputStream nopOuputStream() {
        return new OutputStream(){

            @Override
            public void write(int paramInt) throws IOException {
            }
        };
    }

    public static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeifClosable(Object closeable) {
        if (closeable != null && closeable instanceof Closeable) {
            try {
                ((Closeable)closeable).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeOrFail(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot close " + closeable, e);
            }
        }
    }

    public static FileInputStream inputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException("File " + file + " not found.", e);
        }
    }

    public static FileOutputStream outputStream(File file, boolean append) {
        try {
            return new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + file + " not found.", e);
        }
    }

    public static InputStream inputStream(URL file) {
        try {
            return file.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int read(InputStream inputStream) {
        try {
            return inputStream.read();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<String> readAsLines(InputStream in) {
        LinkedList<String> result = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(URL url) {
        try (InputStream is = url.openStream();){
            String string = JkUtilsIO.readAsString(is);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readAsString(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder out = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        boolean firstTime = true;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!firstTime) {
                    out.append(newLine);
                }
                out.append(line);
                firstTime = false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toString();
    }

    public static void closeQuietly(ZipFile ... zipFiles) {
        for (ZipFile zipFile : zipFiles) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static Path copyUrlContentToCacheFile(URL url, PrintStream report, Path cacheDir) {
        String name = JkUtilsString.substringAfterLast(url.getPath(), "/");
        Path result = cacheDir.resolve(name);
        if (Files.exists(result, new LinkOption[0])) {
            if (report != null) {
                report.println("Url " + url.toExternalForm() + " transformed to file by reading existing cached file " + result);
            }
            return result;
        }
        JkUtilsPath.createFileSafely(result, new FileAttribute[0]);
        if (report != null) {
            report.println("Url " + url.toExternalForm() + " transformed to file by creating file " + result);
        }
        JkUtilsIO.copyUrlToFile(url, result);
        return result;
    }

    public static void copyUrlToFile(URL url, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            JkUtilsPath.createFile(file, new FileAttribute[0]);
        }
        try (OutputStream fileOutputStream = Files.newOutputStream(file, new OpenOption[0]);
             InputStream inputStream = url.openStream();){
            JkUtilsIO.copy(inputStream, fileOutputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyUrlToFile(String url, Path file) {
        JkUtilsIO.copyUrlToFile(JkUtilsIO.toUrl(url), file);
    }

    public static void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(OutputStream outputStream, byte[] bytes) {
        try {
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void serialize(Object object, Path file) {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            JkUtilsIO.serialize(object, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException("File must exist.", e);
        }
    }

    public static void serialize(Object object, OutputStream outputStream) {
        try {
            BufferedOutputStream buffer = new BufferedOutputStream(outputStream);
            try (ObjectOutputStream output = new ObjectOutputStream(buffer);){
                output.writeObject(object);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while serializing " + object, e);
        }
    }

    public static <T> T deserialize(Path file) {
        try {
            return JkUtilsIO.deserialize(Files.newInputStream(file, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T deserialize(InputStream inputStream) {
        return JkUtilsIO.deserialize(inputStream, JkUtilsIO.class.getClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream, final ClassLoader classLoader) {
        try (BufferedInputStream buffer = new BufferedInputStream(inputStream);){
            ObjectInputStream input = new ObjectInputStream(buffer){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, classLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        Class cl = (Class)primClasses.get(name);
                        if (cl != null) {
                            return cl;
                        }
                        throw ex;
                    }
                }
            };
            Object object = input.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T cloneBySerialization(Object objectToClone, ClassLoader targetClassLoader) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        JkUtilsIO.serialize(objectToClone, arrayOutputStream);
        byte[] bytes = arrayOutputStream.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        return JkUtilsIO.deserialize(bin, targetClassLoader);
    }

    public static JkStreamGobbler newStreamGobbler(InputStream is, OutputStream ... outputStreams) {
        return new JkStreamGobbler(is, outputStreams);
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    public static final class JkStreamGobbler {
        private final InnerRunnable innerRunnable;
        private final Thread thread;

        private JkStreamGobbler(InputStream is, OutputStream ... outputStreams) {
            this.innerRunnable = new InnerRunnable(is, outputStreams);
            this.thread = new Thread(this.innerRunnable);
            this.thread.start();
        }

        public void stop() {
            this.innerRunnable.stop.set(true);
        }

        public void join() {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        private static class InnerRunnable
        implements Runnable {
            private final InputStream in;
            private final OutputStream[] outs;
            private final AtomicBoolean stop = new AtomicBoolean(false);

            private InnerRunnable(InputStream is, OutputStream[] outputStreams) {
                this.in = is;
                this.outs = outputStreams;
            }

            @Override
            public void run() {
                try (InputStreamReader isr = new InputStreamReader(this.in);
                     BufferedReader br = new BufferedReader(isr);){
                    while (!this.stop.get()) {
                        int c = br.read();
                        if (c == -1) {
                            break;
                        }
                        for (OutputStream out : this.outs) {
                            out.write((char)c);
                            out.flush();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

